/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandAddMethod;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClass;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.classdiagram.command.CommandDiamondAssociation;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShow;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShow3;
import net.sourceforge.plantuml.classdiagram.command.CommandImport;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkLollipop;
import net.sourceforge.plantuml.classdiagram.command.CommandMouseOver;
import net.sourceforge.plantuml.classdiagram.command.CommandNamespaceSeparator;
import net.sourceforge.plantuml.classdiagram.command.CommandStereotype;
import net.sourceforge.plantuml.classdiagram.command.CommandUrl;
import net.sourceforge.plantuml.command.AbstractUmlSystemCommandFactory;
import net.sourceforge.plantuml.command.CommandEndNamespace;
import net.sourceforge.plantuml.command.CommandEndPackage;
import net.sourceforge.plantuml.command.CommandNamespace;
import net.sourceforge.plantuml.command.CommandPackage;
import net.sourceforge.plantuml.command.CommandPackageEmpty;
import net.sourceforge.plantuml.command.CommandPage;
import net.sourceforge.plantuml.command.CommandRankDir;
import net.sourceforge.plantuml.command.note.FactoryNoteCommand;
import net.sourceforge.plantuml.command.note.FactoryNoteOnEntityCommand;
import net.sourceforge.plantuml.command.note.FactoryNoteOnLinkCommand;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDiagramFactory
extends AbstractUmlSystemCommandFactory {
    private ClassDiagram system;

    @Override
    public ClassDiagram getSystem() {
        return this.system;
    }

    @Override
    protected void initCommands() {
        this.system = new ClassDiagram();
        this.addCommonCommands(this.system);
        this.addCommand(new CommandRankDir(this.system));
        this.addCommand(new CommandPage(this.system));
        this.addCommand(new CommandAddMethod(this.system));
        this.addCommand(new CommandCreateClass(this.system));
        FactoryNoteCommand factoryNoteCommand = new FactoryNoteCommand();
        this.addCommand(factoryNoteCommand.createSingleLine(this.system));
        this.addCommand(new CommandPackage(this.system));
        this.addCommand(new CommandEndPackage(this.system));
        this.addCommand(new CommandPackageEmpty(this.system));
        this.addCommand(new CommandNamespace(this.system));
        this.addCommand(new CommandEndNamespace(this.system));
        this.addCommand(new CommandStereotype(this.system));
        this.addCommand(new CommandLinkClass(this.system));
        this.addCommand(new CommandLinkLollipop(this.system));
        this.addCommand(new CommandImport(this.system));
        FactoryNoteOnEntityCommand factoryNoteOnEntityCommand = new FactoryNoteOnEntityCommand(new RegexLeaf("ENTITY", "([^\\s{}\"<>]+|\"[^\"]+\")"));
        this.addCommand(factoryNoteOnEntityCommand.createSingleLine(this.system));
        this.addCommand(new CommandUrl(this.system));
        this.addCommand(factoryNoteOnEntityCommand.createMultiLine(this.system));
        this.addCommand(factoryNoteCommand.createMultiLine(this.system));
        this.addCommand(new CommandCreateClassMultilines(this.system));
        FactoryNoteOnLinkCommand factoryNoteOnLinkCommand = new FactoryNoteOnLinkCommand();
        this.addCommand(factoryNoteOnLinkCommand.createSingleLine(this.system));
        this.addCommand(factoryNoteOnLinkCommand.createMultiLine(this.system));
        this.addCommand(new CommandDiamondAssociation(this.system));
        this.addCommand(new CommandMouseOver(this.system));
        this.addCommand(new CommandHideShow3(this.system));
        this.addCommand(new CommandHideShow(this.system));
        this.addCommand(new CommandNamespaceSeparator(this.system));
    }

    @Override
    public String checkFinalError() {
        for (IGroup iGroup : this.system.getGroups(true)) {
            ArrayList<ILeaf> arrayList = new ArrayList<ILeaf>();
            for (ILeaf iLeaf : iGroup.getLeafsDirect()) {
                if (!this.system.isStandalone(iLeaf)) continue;
                arrayList.add(iLeaf);
            }
            if (arrayList.size() < 3) continue;
            this.putInSquare(arrayList);
        }
        return super.checkFinalError();
    }

    private void putInSquare(List<ILeaf> list) {
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getInvisible();
        int n = ClassDiagramFactory.computeBranch(list.size());
        int n2 = 0;
        for (int i = 1; i < list.size(); ++i) {
            Link link;
            IEntity iEntity;
            int n3 = i - n2;
            IEntity iEntity2 = list.get(i);
            if (n3 == n) {
                iEntity = list.get(n2);
                link = new Link(iEntity, iEntity2, linkType, null, 2);
                n2 = i;
            } else {
                iEntity = list.get(i - 1);
                link = new Link(iEntity, iEntity2, linkType, null, 1);
            }
            this.system.addLink(link);
        }
    }

    static int computeBranch(int n) {
        double d = Math.sqrt(n);
        int n2 = (int)d;
        if (n2 * n2 == n) {
            return n2;
        }
        return n2 + 1;
    }
}

