/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.GenericRegexProducer;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateClass
extends SingleLineCommand2<ClassDiagram> {
    public static final String CODE = "[^\\s{}\"<>]+";

    public CommandCreateClass(ClassDiagram classDiagram) {
        super(classDiagram, CommandCreateClass.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(interface|enum|abstract\\s+class|abstract|class)\\s+"), new RegexOr(new RegexConcat(new RegexLeaf("DISPLAY1", "\"([^\"]+)\""), new RegexLeaf("\\s+as\\s+"), new RegexLeaf("CODE1", "([^\\s{}\"<>]+)")), new RegexConcat(new RegexLeaf("CODE2", "([^\\s{}\"<>]+)"), new RegexLeaf("\\s+as\\s+"), new RegexLeaf("DISPLAY2", "\"([^\"]+)\"")), new RegexLeaf("CODE3", "([^\\s{}\"<>]+)"), new RegexLeaf("CODE4", "\"([^\"]+)\"")), new RegexLeaf("GENERIC", "(?:\\s*\\<(" + GenericRegexProducer.PATTERN + ")\\>)?"), new RegexLeaf("STEREO", "(?:\\s*(\\<{2}.*\\>{2}))?"), new RegexLeaf("\\s*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("EXTENDS", "(\\s+(extends|implements)\\s+(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*))?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        String string;
        ILeaf iLeaf;
        LeafType leafType = LeafType.getLeafType(regexResult.get("TYPE", 0).toUpperCase());
        Code code = Code.of(regexResult.getLazzy("CODE", 0)).eventuallyRemoveStartingAndEndingDoubleQuote();
        String string2 = regexResult.getLazzy("DISPLAY", 0);
        String string3 = regexResult.get("STEREO", 0);
        String string4 = regexResult.get("GENERIC", 0);
        if (((ClassDiagram)this.getSystem()).leafExist(code)) {
            iLeaf = ((ClassDiagram)this.getSystem()).getOrCreateLeaf1(code, leafType);
            iLeaf.muteToType(leafType);
        } else {
            iLeaf = ((ClassDiagram)this.getSystem()).createLeaf(code, StringUtils.getWithNewlines(string2), leafType);
        }
        if (string3 != null) {
            iLeaf.setStereotype(new Stereotype(string3, ((ClassDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((ClassDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        if (string4 != null) {
            iLeaf.setGeneric(string4);
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(((ClassDiagram)this.getSystem()).getSkinParam().getValue("topurl"), true);
            Url url = urlBuilder.getUrl(string);
            iLeaf.addUrl(url);
        }
        iLeaf.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("COLOR", 0)));
        CommandCreateClass.manageExtends((ClassDiagram)this.getSystem(), regexResult, iLeaf);
        return CommandExecutionResult.ok();
    }

    public static void manageExtends(ClassDiagram classDiagram, RegexResult regexResult, IEntity iEntity) {
        if (regexResult.get("EXTENDS", 1) != null) {
            Mode mode = regexResult.get("EXTENDS", 1).equalsIgnoreCase("extends") ? Mode.EXTENDS : Mode.IMPLEMENTS;
            Code code = Code.of(regexResult.get("EXTENDS", 2));
            LeafType leafType = LeafType.CLASS;
            if (mode == Mode.IMPLEMENTS) {
                leafType = LeafType.INTERFACE;
            }
            if (mode == Mode.EXTENDS && iEntity.getEntityType() == LeafType.INTERFACE) {
                leafType = LeafType.INTERFACE;
            }
            ILeaf iLeaf = classDiagram.getOrCreateLeaf1(code, leafType);
            LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.EXTENDS);
            if (leafType == LeafType.INTERFACE && iEntity.getEntityType() != LeafType.INTERFACE) {
                linkType = linkType.getDashed();
            }
            Link link = new Link(iLeaf, iEntity, linkType, null, 2, null, null, classDiagram.getLabeldistance(), classDiagram.getLabelangle());
            classDiagram.addLink(link);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

