/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLinkLollipop
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandLinkLollipop(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram) {
        super(abstractClassOrObjectDiagram, CommandLinkLollipop.getRegexConcat(abstractClassOrObjectDiagram.getUmlDiagramType()));
    }

    static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return new RegexConcat(new RegexLeaf("HEADER", "^(?:@([\\d.]+)\\s+)?"), new RegexLeaf("ENT1", "(?:" + CommandLinkLollipop.optionalKeywords(umlDiagramType) + "\\s+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|\"[^\"]+\")\\s*(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("FIRST_LABEL", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), new RegexOr(new RegexLeaf("LOL_THEN_ENT", "\\(\\)([-=.]+)"), new RegexLeaf("ENT_THEN_LOL", "([-=.]+)\\(\\)")), new RegexLeaf("\\s*"), new RegexLeaf("SECOND_LABEL", "(?:\"([^\"]+)\")?"), new RegexLeaf("\\s*"), new RegexLeaf("ENT2", "(?:" + CommandLinkLollipop.optionalKeywords(umlDiagramType) + "\\s+)?" + "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*|\"[^\"]+\")\\s*(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("LABEL_LINK", "(?::\\s*(.+))?"), new RegexLeaf("$"));
    }

    private static String optionalKeywords(UmlDiagramType umlDiagramType) {
        if (umlDiagramType == UmlDiagramType.CLASS) {
            return "(interface|enum|abstract\\s+class|abstract|class)";
        }
        if (umlDiagramType == UmlDiagramType.OBJECT) {
            return "(object)";
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        Object object;
        IEntity iEntity;
        IEntity iEntity2;
        IEntity iEntity3;
        Code code = Code.of(regexResult.get("ENT1", 1));
        Code code2 = Code.of(regexResult.get("ENT2", 1));
        String string = "lol" + UniqueSequence.getValue();
        if (regexResult.get("LOL_THEN_ENT", 0) == null) {
            assert (regexResult.get("ENT_THEN_LOL", 0) != null);
            iEntity3 = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateLeaf1(code, null);
            iEntity2 = ((AbstractClassOrObjectDiagram)this.getSystem()).createLeaf(iEntity3.getCode().addSuffix(string), StringUtils.getWithNewlines(code2), LeafType.LOLLIPOP);
            iEntity = iEntity3;
        } else {
            iEntity2 = ((AbstractClassOrObjectDiagram)this.getSystem()).getOrCreateLeaf1(code2, null);
            iEntity3 = ((AbstractClassOrObjectDiagram)this.getSystem()).createLeaf(iEntity2.getCode().addSuffix(string), StringUtils.getWithNewlines(code), LeafType.LOLLIPOP);
            iEntity = iEntity2;
        }
        LinkType linkType = this.getLinkType(regexResult);
        String string2 = this.getQueue(regexResult);
        int n = string2.length();
        if (n == 1 && ((AbstractClassOrObjectDiagram)this.getSystem()).getNbOfHozizontalLollipop(iEntity) > 1) {
            ++n;
        }
        String string3 = regexResult.get("FIRST_LABEL", 0);
        String string4 = regexResult.get("SECOND_LABEL", 0);
        String string5 = null;
        if (regexResult.get("LABEL_LINK", 0) != null) {
            string5 = regexResult.get("LABEL_LINK", 0);
            if (string3 == null && string4 == null) {
                object = Pattern.compile("^\"([^\"]+)\"([^\"]+)\"([^\"]+)\"$");
                Matcher matcher = ((Pattern)object).matcher(string5);
                if (matcher.matches()) {
                    string3 = matcher.group(1);
                    string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher.group(2).trim()).trim();
                    string4 = matcher.group(3);
                } else {
                    Pattern pattern = Pattern.compile("^\"([^\"]+)\"([^\"]+)$");
                    Matcher matcher2 = pattern.matcher(string5);
                    if (matcher2.matches()) {
                        string3 = matcher2.group(1);
                        string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher2.group(2).trim()).trim();
                        string4 = null;
                    } else {
                        Pattern pattern2 = Pattern.compile("^([^\"]+)\"([^\"]+)\"$");
                        Matcher matcher3 = pattern2.matcher(string5);
                        if (matcher3.matches()) {
                            string3 = null;
                            string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher3.group(1).trim()).trim();
                            string4 = matcher3.group(2);
                        }
                    }
                }
            }
            string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string5);
        }
        object = new Link(iEntity3, iEntity2, linkType, string5, n, string3, string4, ((AbstractClassOrObjectDiagram)this.getSystem()).getLabeldistance(), ((AbstractClassOrObjectDiagram)this.getSystem()).getLabelangle());
        ((AbstractClassOrObjectDiagram)this.getSystem()).resetPragmaLabel();
        this.addLink((Link)object, regexResult.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private void addLink(Link link, String string) {
        ((AbstractClassOrObjectDiagram)this.getSystem()).addLink(link);
        if (string != null) {
            link.setWeight(Double.parseDouble(string));
        }
    }

    private LinkType getLinkType(RegexResult regexResult) {
        return new LinkType(LinkDecor.NONE, LinkDecor.NONE);
    }

    private String getQueue(RegexResult regexResult) {
        if (regexResult.get("LOL_THEN_ENT", 0) != null) {
            return regexResult.get("LOL_THEN_ENT", 0).trim();
        }
        if (regexResult.get("ENT_THEN_LOL", 0) != null) {
            return regexResult.get("ENT_THEN_LOL", 0).trim();
        }
        throw new IllegalArgumentException();
    }
}

