/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandNamespace
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandNamespace(AbstractEntityDiagram abstractEntityDiagram) {
        super(abstractEntityDiagram, CommandNamespace.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^namespace\\s+"), new RegexLeaf("NAME", "([\\p{L}0-9_][\\p{L}0-9_.:]*)"), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("\\s*\\{?$"));
    }

    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        String string;
        Code code = Code.of(regexResult.get("NAME", 0));
        IGroup iGroup = ((AbstractEntityDiagram)this.getSystem()).getCurrentGroup();
        IGroup iGroup2 = ((AbstractEntityDiagram)this.getSystem()).getOrCreateGroup(code, StringUtils.getWithNewlines(code), code.getCode(), GroupType.PACKAGE, iGroup);
        String string2 = regexResult.get("STEREOTYPE", 0);
        if (string2 != null) {
            iGroup2.setStereotype(new Stereotype(string2));
        }
        if ((string = regexResult.get("COLOR", 0)) != null) {
            iGroup2.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(string));
        }
        return CommandExecutionResult.ok();
    }
}

