/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandPackageEmpty
extends SingleLineCommand<AbstractEntityDiagram> {
    public CommandPackageEmpty(AbstractEntityDiagram abstractEntityDiagram) {
        super(abstractEntityDiagram, "(?i)^package\\s+(\"[^\"]+\"|[^#\\s{}]*)(?:\\s+as\\s+([\\p{L}0-9_.]+))?\\s*(#[0-9a-fA-F]{6}|#?\\w+)?\\s*\\{\\s*\\}$");
    }

    @Override
    protected CommandExecutionResult executeArg(List<String> list) {
        String string;
        Code code;
        if (list.get(1) == null) {
            if (StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(0)).length() == 0) {
                code = Code.of("##" + UniqueSequence.getValue());
                string = null;
            } else {
                code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(0)));
                string = code.getCode();
            }
        } else {
            string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(0));
            code = Code.of(list.get(1));
        }
        IGroup iGroup = ((AbstractEntityDiagram)this.getSystem()).getCurrentGroup();
        IGroup iGroup2 = ((AbstractEntityDiagram)this.getSystem()).getOrCreateGroup(code, StringUtils.getWithNewlines(string), null, GroupType.PACKAGE, iGroup);
        String string2 = list.get(2);
        if (string2 != null) {
            iGroup2.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(string2));
        }
        ((AbstractEntityDiagram)this.getSystem()).endGroup();
        return CommandExecutionResult.ok();
    }
}

