/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryNoteCommand
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^(note)\\s+"), new RegexLeaf("CODE", "as\\s+([\\p{L}0-9_.]+)"), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^note\\s+"), new RegexLeaf("DISPLAY", "\"([^\"]+)\"\\s+as\\s+"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("$"));
    }

    @Override
    public Command createSingleLine(AbstractEntityDiagram abstractEntityDiagram) {
        return new SingleLineCommand2<AbstractEntityDiagram>(abstractEntityDiagram, this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(RegexResult regexResult) {
                String string = regexResult.get("DISPLAY", 0);
                return FactoryNoteCommand.this.executeInternal((AbstractEntityDiagram)this.getSystem(), regexResult, StringUtils.getWithNewlines(string));
            }
        };
    }

    @Override
    public Command createMultiLine(AbstractEntityDiagram abstractEntityDiagram) {
        return new CommandMultilines2<AbstractEntityDiagram>(abstractEntityDiagram, this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end ?note$";
            }

            @Override
            public CommandExecutionResult executeNow(List<String> list) {
                StringUtils.trim(list, false);
                RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
                List<String> list2 = StringUtils.removeEmptyColumns(list.subList(1, list.size() - 1));
                return FactoryNoteCommand.this.executeInternal((AbstractEntityDiagram)this.getSystem(), regexResult, list2);
            }
        };
    }

    private CommandExecutionResult executeInternal(AbstractEntityDiagram abstractEntityDiagram, RegexResult regexResult, List<? extends CharSequence> list) {
        Code code = Code.of(regexResult.get("CODE", 0));
        ILeaf iLeaf = abstractEntityDiagram.createLeaf(code, list, LeafType.NOTE);
        assert (iLeaf != null);
        iLeaf.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }
}

