/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.regex;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexLeaf
implements IRegex {
    private final Pattern pattern;
    private final String name;
    private int count = -1;

    public RegexLeaf(String string) {
        this(null, string);
    }

    public RegexLeaf(String string, String string2) {
        this.pattern = Pattern.compile(string2, 2);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getPattern() {
        return this.pattern.pattern();
    }

    @Override
    public int count() {
        if (this.count == -1) {
            this.count = this.pattern.matcher("").groupCount();
        }
        return this.count;
    }

    @Override
    public Map<String, RegexPartialMatch> createPartialMatch(Iterator<String> iterator) {
        RegexPartialMatch regexPartialMatch = new RegexPartialMatch(this.name);
        for (int i = 0; i < this.count(); ++i) {
            String string = iterator.next();
            regexPartialMatch.add(string);
        }
        if (this.name == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.name, regexPartialMatch);
    }
}

