/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public class MemberImpl
implements Member {
    private final String display;
    private final boolean staticModifier;
    private final boolean abstractModifier;
    private final Url url;
    private final VisibilityModifier visibilityModifier;

    public MemberImpl(String string, boolean bl) {
        Object object;
        Pattern pattern = Pattern.compile("^(.*)(" + UrlBuilder.getRegexp() + ")(.*)$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            if (matcher.groupCount() != 6) {
                throw new IllegalStateException();
            }
            object = new UrlBuilder(null, true);
            this.url = ((UrlBuilder)object).getUrl(matcher.group(2));
            this.url.setMember(true);
            string = matcher.group(1).trim() + matcher.group(matcher.groupCount()).trim();
        } else {
            this.url = null;
        }
        object = string.toLowerCase();
        this.staticModifier = ((String)object).contains("{static}") || ((String)object).contains("{classifier}");
        this.abstractModifier = ((String)object).contains("{abstract}");
        String string2 = string.replaceAll("(?i)\\{(static|classifier|abstract)\\}", "").trim();
        if (string2.length() == 0) {
            string2 = " ";
        }
        if (VisibilityModifier.isVisibilityCharacter(string2.charAt(0))) {
            this.visibilityModifier = VisibilityModifier.getVisibilityModifier(string.charAt(0), !bl);
            this.display = string2.substring(1).trim();
        } else {
            this.display = string2;
            this.visibilityModifier = null;
        }
    }

    public String getDisplay(boolean bl) {
        if (bl) {
            return this.getDisplayWithVisibilityChar();
        }
        return this.getDisplayWithoutVisibilityChar();
    }

    public String getDisplayWithoutVisibilityChar() {
        return this.display;
    }

    public String getDisplayWithVisibilityChar() {
        if (this.isPrivate()) {
            return "-" + this.display;
        }
        if (this.isPublic()) {
            return "+" + this.display;
        }
        if (this.isPackagePrivate()) {
            return "~" + this.display;
        }
        if (this.isProtected()) {
            return "#" + this.display;
        }
        return this.display;
    }

    public boolean equals(Object object) {
        MemberImpl memberImpl = (MemberImpl)object;
        return this.display.equals(memberImpl.display);
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public final boolean isStatic() {
        return this.staticModifier;
    }

    public final boolean isAbstract() {
        return this.abstractModifier;
    }

    private boolean isPrivate() {
        return this.visibilityModifier == VisibilityModifier.PRIVATE_FIELD || this.visibilityModifier == VisibilityModifier.PRIVATE_METHOD;
    }

    private boolean isProtected() {
        return this.visibilityModifier == VisibilityModifier.PROTECTED_FIELD || this.visibilityModifier == VisibilityModifier.PROTECTED_METHOD;
    }

    private boolean isPublic() {
        return this.visibilityModifier == VisibilityModifier.PUBLIC_FIELD || this.visibilityModifier == VisibilityModifier.PUBLIC_METHOD;
    }

    private boolean isPackagePrivate() {
        return this.visibilityModifier == VisibilityModifier.PACKAGE_PRIVATE_FIELD || this.visibilityModifier == VisibilityModifier.PACKAGE_PRIVATE_METHOD;
    }

    public final VisibilityModifier getVisibilityModifier() {
        return this.visibilityModifier;
    }

    public final Url getUrl() {
        return this.url;
    }
}

