/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.USymbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateElementFull
extends SingleLineCommand2<DescriptionDiagram> {
    private static final String CODE_CORE = "[\\p{L}0-9_.]+|\\(\\)\\s*[\\p{L}0-9_.]+|\\(\\)\\s*\"[^\"]+\"|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    private static final String CODE = "([\\p{L}0-9_.]+|\\(\\)\\s*[\\p{L}0-9_.]+|\\(\\)\\s*\"[^\"]+\"|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    private static final String CODE_WITH_QUOTE = "([\\p{L}0-9_.]+|\\(\\)\\s*[\\p{L}0-9_.]+|\\(\\)\\s*\"[^\"]+\"|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|\"[^\"]+\")";
    private static final String DISPLAY_CORE = "\"[^\"]+\"|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    private static final String DISPLAY = "(\"[^\"]+\"|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    private static final String DISPLAY_WITHOUT_QUOTE = "(\"[^\"]+\"|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[\\p{L}0-9_.]+)";

    public CommandCreateElementFull(DescriptionDiagram descriptionDiagram) {
        super(descriptionDiagram, CommandCreateElementFull.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("SYMBOL", "(?:(artifact|actor|folder|rect|node|frame|cloud|database|storage|agent|usecase|component|boundary|control|entity|interface|\\(\\))\\s+)?"), new RegexLeaf("\\s*"), new RegexOr(new RegexLeaf("CODE1", CODE_WITH_QUOTE), new RegexConcat(new RegexLeaf("DISPLAY2", DISPLAY), new RegexLeaf("STEREOTYPE2", "(?:\\s+(\\<\\<.+\\>\\>))?"), new RegexLeaf("\\s*as\\s+"), new RegexLeaf("CODE2", CODE)), new RegexConcat(new RegexLeaf("CODE3", CODE), new RegexLeaf("STEREOTYPE3", "(?:\\s+(\\<\\<.+\\>\\>))?"), new RegexLeaf("\\s+as\\s*"), new RegexLeaf("DISPLAY3", DISPLAY)), new RegexConcat(new RegexLeaf("DISPLAY4", DISPLAY_WITHOUT_QUOTE), new RegexLeaf("STEREOTYPE4", "(?:\\s+(\\<\\<.+\\>\\>))?"), new RegexLeaf("\\s*as\\s+"), new RegexLeaf("CODE4", CODE))), new RegexLeaf("STEREOTYPE", "(?:\\s*(\\<\\<.+\\>\\>))?"), new RegexLeaf("\\s*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("$"));
    }

    @Override
    protected final boolean isForbidden(String string) {
        return string.matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        String string;
        USymbol uSymbol;
        LeafType leafType;
        String string2;
        String string3 = regexResult.getLazzy("CODE", 0);
        String string4 = regexResult.getLazzy("DISPLAY", 0);
        char c = this.getCharEncoding(string3);
        char c2 = this.getCharEncoding(string4);
        if (string3.startsWith("()")) {
            string2 = "interface";
            string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string3.substring(2).trim());
        } else {
            string2 = c == '(' || c2 == '(' ? "usecase" : (c == ':' || c2 == ':' ? "actor" : (c == '[' || c2 == '[' ? "component" : regexResult.get("SYMBOL", 0)));
        }
        if (string2 == null) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.ACTOR;
        } else if (string2.equalsIgnoreCase("artifact")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.ARTIFACT;
        } else if (string2.equalsIgnoreCase("folder")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.FOLDER;
        } else if (string2.equalsIgnoreCase("rect")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.RECT;
        } else if (string2.equalsIgnoreCase("node")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.NODE;
        } else if (string2.equalsIgnoreCase("frame")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.FRAME;
        } else if (string2.equalsIgnoreCase("cloud")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.CLOUD;
        } else if (string2.equalsIgnoreCase("database")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.DATABASE;
        } else if (string2.equalsIgnoreCase("storage")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.STORAGE;
        } else if (string2.equalsIgnoreCase("agent")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.RECT;
        } else if (string2.equalsIgnoreCase("actor")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.ACTOR;
        } else if (string2.equalsIgnoreCase("component")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = ((DescriptionDiagram)this.getSystem()).getSkinParam().useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1;
        } else if (string2.equalsIgnoreCase("boundary")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.BOUNDARY;
        } else if (string2.equalsIgnoreCase("control")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.CONTROL;
        } else if (string2.equalsIgnoreCase("entity")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.ENTITY_DOMAIN;
        } else if (string2.equalsIgnoreCase("interface")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.INTERFACE;
        } else if (string2.equalsIgnoreCase("()")) {
            leafType = LeafType.COMPONENT2;
            uSymbol = USymbol.INTERFACE;
        } else if (string2.equalsIgnoreCase("usecase")) {
            leafType = LeafType.USECASE;
            uSymbol = null;
        } else {
            throw new IllegalStateException();
        }
        Code code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string3));
        String string5 = string4;
        if (string5 == null) {
            string5 = code.getCode();
        }
        string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string5);
        String string6 = regexResult.getLazzy("STEREOTYPE", 0);
        ILeaf iLeaf = ((DescriptionDiagram)this.getSystem()).getOrCreateLeaf1(code, leafType);
        iLeaf.setDisplay(StringUtils.getWithNewlines(string5));
        iLeaf.setUSymbol(uSymbol);
        if (string6 != null) {
            iLeaf.setStereotype(new Stereotype(string6, ((DescriptionDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((DescriptionDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(((DescriptionDiagram)this.getSystem()).getSkinParam().getValue("topurl"), true);
            Url url = urlBuilder.getUrl(string);
            iLeaf.addUrl(url);
        }
        iLeaf.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }

    private char getCharEncoding(String string) {
        return string != null && string.length() > 2 ? string.charAt(0) : (char)'\u0000';
    }
}

