/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.USymbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandPackageWithUSymbol
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPackageWithUSymbol(AbstractEntityDiagram abstractEntityDiagram) {
        super(abstractEntityDiagram, CommandPackageWithUSymbol.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("SYMBOL", "(package|rectangle|node|artifact|folder|frame|cloud|database|storage)"), new RegexLeaf("\\s+"), new RegexLeaf("NAME", "(\"[^\"]+\"|[^#\\s{}]*)"), new RegexLeaf("AS", "(?:\\s+as\\s+([\\p{L}0-9_.]+))?"), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#[0-9a-fA-F]{6}|#?\\w+)?"), new RegexLeaf("\\s*\\{$"));
    }

    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        String string;
        String string2;
        Code code;
        String string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("NAME", 0));
        if (regexResult.get("AS", 0) == null) {
            if (string3.length() == 0) {
                code = UniqueSequence.getCode("##");
                string2 = null;
            } else {
                code = Code.of(string3);
                string2 = code.getCode();
            }
        } else {
            string2 = string3;
            code = Code.of(regexResult.get("AS", 0));
        }
        IGroup iGroup = ((AbstractEntityDiagram)this.getSystem()).getCurrentGroup();
        IGroup iGroup2 = ((AbstractEntityDiagram)this.getSystem()).getOrCreateGroup(code, StringUtils.getWithNewlines(string2), null, GroupType.PACKAGE, iGroup);
        iGroup2.setUSymbol(USymbol.getFromString(regexResult.get("SYMBOL", 0)));
        String string4 = regexResult.get("STEREOTYPE", 0);
        if (string4 != null) {
            iGroup2.setStereotype(new Stereotype(string4, false));
        }
        if ((string = regexResult.get("COLOR", 0)) != null) {
            iGroup2.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(string));
        }
        return CommandExecutionResult.ok();
    }
}

