/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import java.io.UnsupportedEncodingException;
import net.sourceforge.plantuml.DiagramType;
import net.sourceforge.plantuml.PSystemBasicFactory;
import net.sourceforge.plantuml.ditaa.PSystemDitaa;

public class PSystemDitaaFactory
implements PSystemBasicFactory {
    private StringBuilder data;
    private boolean first;
    private boolean performSeparationOfCommonEdges;
    private boolean dropShadows;
    private final DiagramType diagramType;

    public PSystemDitaaFactory(DiagramType diagramType) {
        this.diagramType = diagramType;
    }

    public void init(String string) {
        this.data = null;
        this.performSeparationOfCommonEdges = true;
        if (string != null && (string.contains("-E") || string.contains("--no-separation"))) {
            this.performSeparationOfCommonEdges = false;
        }
        this.dropShadows = true;
        if (string != null && (string.contains("-S") || string.contains("--no-shadows"))) {
            this.dropShadows = false;
        }
        if (this.diagramType == DiagramType.UML) {
            this.first = true;
        } else if (this.diagramType == DiagramType.DITAA) {
            this.first = false;
            this.data = new StringBuilder();
        } else {
            throw new IllegalStateException(this.diagramType.name());
        }
    }

    public boolean executeLine(String string) {
        if (this.first && (string.equals("ditaa") || string.startsWith("ditaa("))) {
            this.data = new StringBuilder();
            if (string.contains("-E") || string.contains("--no-separation")) {
                this.performSeparationOfCommonEdges = false;
            }
            if (string.contains("-S") || string.contains("--no-shadows")) {
                this.dropShadows = false;
            }
            return true;
        }
        this.first = false;
        if (this.data == null) {
            return false;
        }
        this.data.append(string);
        this.data.append("\n");
        return true;
    }

    public PSystemDitaa getSystem() {
        try {
            return new PSystemDitaa(this.data.toString(), this.performSeparationOfCommonEdges, this.dropShadows);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public DiagramType getDiagramType() {
        return this.diagramType;
    }
}

