/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlocWidthMarged;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockHorizontal;
import net.sourceforge.plantuml.graphic.TextBlockMarged;
import net.sourceforge.plantuml.graphic.TextBlockMinWidth;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.graphic.TextBlockSpotted;
import net.sourceforge.plantuml.graphic.TextBlockVertical;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.graphic.TextBlockWithNumber;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableImpl;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockUtils {
    public static TextBlock create(List<? extends CharSequence> list, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer) {
        if (list.size() > 0) {
            if (list.get(0) instanceof Stereotype) {
                return TextBlockUtils.createStereotype(list, fontConfiguration, horizontalAlignement, spriteContainer, 0);
            }
            if (list.get(list.size() - 1) instanceof Stereotype) {
                return TextBlockUtils.createStereotype(list, fontConfiguration, horizontalAlignement, spriteContainer, list.size() - 1);
            }
            if (list.get(0) instanceof MessageNumber) {
                return TextBlockUtils.createMessageNumber(list, fontConfiguration, horizontalAlignement, spriteContainer);
            }
        }
        return new TextBlockSimple(list, fontConfiguration, horizontalAlignement, spriteContainer);
    }

    private static TextBlock createMessageNumber(List<? extends CharSequence> list, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer) {
        MessageNumber messageNumber = (MessageNumber)list.get(0);
        return new TextBlockWithNumber(messageNumber.getNumber(), list.subList(1, list.size()), fontConfiguration, horizontalAlignement, spriteContainer);
    }

    private static TextBlock createStereotype(List<? extends CharSequence> list, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer, int n) {
        Stereotype stereotype = (Stereotype)list.get(n);
        if (stereotype.isSpotted()) {
            CircledCharacter circledCharacter = new CircledCharacter(stereotype.getCharacter(), stereotype.getRadius(), stereotype.getCircledFont(), stereotype.getHtmlColor(), null, fontConfiguration.getColor());
            if (stereotype.getLabel() == null) {
                return new TextBlockSpotted(circledCharacter, list.subList(1, list.size()), fontConfiguration, horizontalAlignement, spriteContainer);
            }
            return new TextBlockSpotted(circledCharacter, list, fontConfiguration, horizontalAlignement, spriteContainer);
        }
        return new TextBlockSimple(list, fontConfiguration, horizontalAlignement, spriteContainer);
    }

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2) {
        return new TextBlockMarged(textBlock, d, d, d2, d2);
    }

    public static TextBlockWidth withMargin(TextBlockWidth textBlockWidth, double d, double d2) {
        return new TextBlocWidthMarged(textBlockWidth, d, d, d2, d2);
    }

    public static TextBlockWidth withMargin(TextBlockWidth textBlockWidth, double d, double d2, double d3) {
        return new TextBlocWidthMarged(textBlockWidth, d, d, d2, d3);
    }

    public static TextBlock withMinWidth(TextBlock textBlock, double d, HorizontalAlignement horizontalAlignement) {
        return new TextBlockMinWidth(textBlock, d, horizontalAlignement);
    }

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2, double d3, double d4) {
        return new TextBlockMarged(textBlock, d, d2, d3, d4);
    }

    public static TextBlock empty(final double d, final double d2) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d3, double d22) {
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    public static Positionable asPositionable(TextBlock textBlock, StringBounder stringBounder, Point2D point2D) {
        return new PositionableImpl(point2D, textBlock.calculateDimension(stringBounder));
    }

    public static TextBlock fromIEntityImage(final IEntityImage iEntityImage) {
        return new TextBlock(){

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return iEntityImage.getDimension(stringBounder);
            }

            @Override
            public void drawU(UGraphic uGraphic, double d, double d2) {
                iEntityImage.drawU(uGraphic, d, d2);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    public static TextBlock mergeLR(TextBlock textBlock, TextBlock textBlock2) {
        return new TextBlockHorizontal(textBlock, textBlock2);
    }

    public static TextBlock mergeTB(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignement horizontalAlignement) {
        return new TextBlockVertical(textBlock, textBlock2, horizontalAlignement);
    }
}

