/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextBlockVertical
implements TextBlock {
    private final TextBlock b1;
    private final TextBlock b2;
    private final HorizontalAlignement horizontalAlignement;

    public TextBlockVertical(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignement horizontalAlignement) {
        this.b1 = textBlock;
        this.b2 = textBlock2;
        this.horizontalAlignement = horizontalAlignement;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.b1.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.b2.calculateDimension(stringBounder);
        return Dimension2DDouble.mergeTB(dimension2D, dimension2D2);
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        Dimension2D dimension2D2 = this.b1.calculateDimension(uGraphic.getStringBounder());
        Dimension2D dimension2D3 = this.b2.calculateDimension(uGraphic.getStringBounder());
        Dimension2D dimension2D4 = this.b1.calculateDimension(uGraphic.getStringBounder());
        if (this.horizontalAlignement == HorizontalAlignement.CENTER) {
            this.b1.drawU(uGraphic, d + (dimension2D.getWidth() - dimension2D2.getWidth()) / 2.0, d2);
            this.b2.drawU(uGraphic, d + (dimension2D.getWidth() - dimension2D3.getWidth()) / 2.0, d2 + dimension2D4.getHeight());
        } else if (this.horizontalAlignement == HorizontalAlignement.LEFT) {
            this.b1.drawU(uGraphic, d, d2);
            this.b2.drawU(uGraphic, d, d2 + dimension2D4.getHeight());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public List<Url> getUrls() {
        return StringUtils.merge(this.b1.getUrls(), this.b2.getUrls());
    }
}

