/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextBlockWithNumber
extends TextBlockSimple {
    private final TextBlock numText;

    public TextBlockWithNumber(String string, List<? extends CharSequence> list, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer) {
        super(list, fontConfiguration, horizontalAlignement, spriteContainer);
        this.numText = TextBlockUtils.create(Arrays.asList(string), fontConfiguration, HorizontalAlignement.LEFT, spriteContainer);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = this.getNumberWithAndMargin(stringBounder);
        double d2 = this.numText.calculateDimension(stringBounder).getHeight();
        Dimension2D dimension2D = super.calculateDimension(stringBounder);
        return new Dimension2DDouble(dimension2D.getWidth() + d, Math.max(d2, dimension2D.getHeight()));
    }

    private double getNumberWithAndMargin(StringBounder stringBounder) {
        double d = this.numText.calculateDimension(stringBounder).getWidth();
        return d + 4.0;
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d3 = this.numText.calculateDimension(stringBounder).getHeight();
        double d4 = this.calculateDimension(stringBounder).getHeight() - d3;
        this.numText.drawU(uGraphic, d, d2 + d4 / 2.0);
        super.drawU(uGraphic, d + this.getNumberWithAndMargin(stringBounder), d2);
    }
}

