/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;

class USymbolDatabase
extends USymbol {
    USymbolDatabase() {
    }

    private void drawDatabase(UGraphic uGraphic, double d, double d2, double d3, double d4, boolean bl) {
        UPath uPath = new UPath();
        if (bl) {
            uPath.setDeltaShadow(3.0);
        }
        uPath.moveTo(0.0, 10.0);
        uPath.cubicTo(10.0, 0.0, d3 / 2.0 - 10.0, 0.0, d3 / 2.0, 0.0);
        uPath.cubicTo(d3 / 2.0 + 10.0, 0.0, d3 - 10.0, 0.0, d3, 10.0);
        uPath.lineTo(d3, d4 - 10.0);
        uPath.cubicTo(d3 - 10.0, d4, d3 / 2.0 - 10.0, d4, d3 / 2.0, d4);
        uPath.cubicTo(d3 / 2.0 + 10.0, d4, 10.0, d4, 0.0, d4 - 10.0);
        uPath.lineTo(0.0, 10.0);
        uGraphic.draw(d, d2, uPath);
        UPath uPath2 = new UPath();
        uPath2.moveTo(0.0, 10.0);
        uPath2.cubicTo(10.0, 20.0, d3 / 2.0 - 10.0, 20.0, d3 / 2.0, 20.0);
        uPath2.cubicTo(d3 / 2.0 + 10.0, 20.0, d3 - 10.0, 20.0, d3, 10.0);
        uGraphic.draw(d, d2, uPath2);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 20.0, 5.0);
    }

    public TextBlock asSmall(final TextBlock textBlock, final TextBlock textBlock2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d, double d2) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                symbolContext.apply(uGraphic);
                USymbolDatabase.this.drawDatabase(uGraphic, d, d2, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolDatabase.this.getMargin();
                TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignement.CENTER);
                textBlock3.drawU(uGraphic, d + margin.getX1(), d2 + margin.getY1());
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock2.calculateDimension(stringBounder);
                return USymbolDatabase.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d5, double d22) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                symbolContext.apply(uGraphic);
                USymbolDatabase.this.drawDatabase(uGraphic, d5, d22, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                Dimension2D dimension2D2 = textBlock2.calculateDimension(uGraphic.getStringBounder());
                double d3 = (d - dimension2D2.getWidth()) / 2.0;
                textBlock2.drawU(uGraphic, d5 + d3, d22);
                Dimension2D dimension2D3 = textBlock.calculateDimension(uGraphic.getStringBounder());
                double d4 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock.drawU(uGraphic, d5 + d4, d22 + 21.0);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }
}

