/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.salt.element.AbstractElementText;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ElementButton
extends AbstractElementText
implements Element {
    private final double stroke = 2.5;
    private final double marginX = 2.0;
    private final double marginY = 2.0;

    public ElementButton(String string, UFont uFont, SpriteContainer spriteContainer) {
        super(string, uFont, true, spriteContainer);
    }

    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        Dimension2D dimension2D = this.getTextDimensionAt(stringBounder, d + 2.5 + 2.0);
        dimension2D = Dimension2DDouble.delta(dimension2D, 4.0, 4.0);
        return Dimension2DDouble.delta(dimension2D, 5.0);
    }

    public void drawU(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        if (n != 0) {
            return;
        }
        Dimension2D dimension2D2 = this.getPreferredDimension(uGraphic.getStringBounder(), d, d2);
        uGraphic.getParam().setStroke(new UStroke(2.5));
        uGraphic.getParam().setBackcolor(HtmlColorUtils.getColorIfValid("#EEEEEE"));
        uGraphic.draw(d + 2.5, d2 + 2.5, new URectangle(dimension2D2.getWidth() - 5.0, dimension2D2.getHeight() - 5.0, 10.0, 10.0));
        uGraphic.getParam().setBackcolor(null);
        uGraphic.getParam().setStroke(new UStroke());
        Dimension2D dimension2D3 = this.getPureTextDimension(uGraphic.getStringBounder());
        this.drawText(uGraphic, d + (dimension2D2.getWidth() - dimension2D3.getWidth()) / 2.0, d2 + 2.5 + 2.0);
    }
}

