/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementRadioCheckbox
implements Element {
    private static final int RECTANGLE = 10;
    private static final int ELLIPSE = 10;
    private static final int ELLIPSE2 = 4;
    private final TextBlock block;
    private final int margin = 20;
    private final double stroke = 1.5;
    private final boolean radio;
    private final boolean checked;

    public ElementRadioCheckbox(List<String> list, UFont uFont, boolean bl, boolean bl2, SpriteContainer spriteContainer) {
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        this.block = TextBlockUtils.create(list, fontConfiguration, HorizontalAlignement.LEFT, spriteContainer);
        this.radio = bl;
        this.checked = bl2;
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double d, double d2) {
        Dimension2D dimension2D = this.block.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 20.0, 0.0);
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2, int n, Dimension2D dimension2D) {
        if (n != 0) {
            return;
        }
        this.block.drawU(uGraphic, d + 20.0, d2);
        Dimension2D dimension2D2 = this.getPreferredDimension(uGraphic.getStringBounder(), 0.0, 0.0);
        double d3 = dimension2D2.getHeight();
        uGraphic.getParam().setStroke(new UStroke(1.5));
        if (this.radio) {
            uGraphic.getParam().setBackcolor(null);
            uGraphic.draw(d + 2.0, d2 + (d3 - 10.0) / 2.0, new UEllipse(10.0, 10.0));
            if (this.checked) {
                uGraphic.getParam().setBackcolor(uGraphic.getParam().getColor());
                uGraphic.draw(d + 2.0 + 3.0, d2 + (d3 - 4.0) / 2.0, new UEllipse(4.0, 4.0));
                uGraphic.getParam().setBackcolor(null);
            }
        } else {
            uGraphic.getParam().setBackcolor(null);
            uGraphic.draw(d + 2.0, d2 + (d3 - 10.0) / 2.0, new URectangle(10.0, 10.0));
            if (this.checked) {
                uGraphic.getParam().setBackcolor(uGraphic.getParam().getColor());
                UPolygon uPolygon = new UPolygon();
                uPolygon.addPoint(0.0, 0.0);
                uPolygon.addPoint(3.0, 3.0);
                uPolygon.addPoint(10.0, -6.0);
                uPolygon.addPoint(3.0, 1.0);
                uGraphic.draw(d + 3.0, d2 + 6.0, uPolygon);
                uGraphic.getParam().setBackcolor(null);
            }
        }
        uGraphic.getParam().setStroke(new UStroke());
    }
}

