/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.skin.ArrowConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
implements Event {
    private final List<String> label;
    private final ArrowConfiguration arrowConfiguration;
    private final List<LifeEvent> lifeEvents = new ArrayList<LifeEvent>();
    private List<? extends CharSequence> notes;
    private NotePosition notePosition;
    private HtmlColor noteBackColor;
    private Url urlNote;
    private final Url url;
    private final String messageNumber;

    public AbstractMessage(List<String> list, ArrowConfiguration arrowConfiguration, String string) {
        this.url = AbstractMessage.initUrl(list);
        this.label = this.removeUrl(list);
        this.arrowConfiguration = arrowConfiguration;
        this.messageNumber = string;
    }

    @Override
    public final Url getUrl() {
        if (this.url == null) {
            return this.urlNote;
        }
        return this.url;
    }

    private List<String> removeUrl(List<String> list) {
        if (this.url == null) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(UrlBuilder.purgeUrl(list.get(0)));
        arrayList.addAll(list.subList(1, list.size()));
        return arrayList;
    }

    private static Url initUrl(List<String> list) {
        if (list.size() == 0) {
            return null;
        }
        UrlBuilder urlBuilder = new UrlBuilder(null, false);
        return urlBuilder.getUrl(list.get(0).trim());
    }

    public final boolean addLifeEvent(LifeEvent lifeEvent) {
        HashSet<Participant> hashSet = new HashSet<Participant>();
        for (LifeEvent lifeEvent2 : this.lifeEvents) {
            if (lifeEvent2.getType() != LifeEventType.DEACTIVATE && lifeEvent2.getType() != LifeEventType.DESTROY) continue;
            hashSet.add(lifeEvent2.getParticipant());
        }
        if (lifeEvent.getType() == LifeEventType.ACTIVATE && hashSet.contains(lifeEvent.getParticipant())) {
            return false;
        }
        this.lifeEvents.add(lifeEvent);
        return true;
    }

    public final boolean isCreate() {
        for (LifeEvent lifeEvent : this.lifeEvents) {
            if (lifeEvent.getType() != LifeEventType.CREATE) continue;
            return true;
        }
        return false;
    }

    public final boolean isActivateAndDeactive() {
        if (this.lifeEvents.size() < 2) {
            return false;
        }
        return this.lifeEvents.get(0).getType() == LifeEventType.ACTIVATE && (this.lifeEvents.get(1).getType() == LifeEventType.DEACTIVATE || this.lifeEvents.get(1).getType() == LifeEventType.DESTROY);
    }

    public final List<LifeEvent> getLiveEvents() {
        return Collections.unmodifiableList(this.lifeEvents);
    }

    public final List<String> getLabel() {
        return Collections.unmodifiableList(this.label);
    }

    public final ArrowConfiguration getArrowConfiguration() {
        return this.arrowConfiguration;
    }

    public final List<? extends CharSequence> getNote() {
        return this.notes == null ? this.notes : Collections.unmodifiableList(this.notes);
    }

    public final Url getUrlNote() {
        return this.urlNote;
    }

    public final void setNote(List<? extends CharSequence> list, NotePosition notePosition, String string, Url url) {
        if (notePosition != NotePosition.LEFT && notePosition != NotePosition.RIGHT) {
            throw new IllegalArgumentException();
        }
        this.notes = list;
        this.urlNote = url;
        this.notePosition = this.overideNotePosition(notePosition);
        this.noteBackColor = HtmlColorUtils.getColorIfValid(string);
    }

    protected NotePosition overideNotePosition(NotePosition notePosition) {
        return notePosition;
    }

    public final HtmlColor getSpecificBackColor() {
        return this.noteBackColor;
    }

    public final NotePosition getNotePosition() {
        return this.notePosition;
    }

    public final String getMessageNumber() {
        return this.messageNumber;
    }

    public boolean isActivate() {
        for (LifeEvent lifeEvent : this.lifeEvents) {
            if (lifeEvent.getType() != LifeEventType.ACTIVATE) continue;
            return true;
        }
        return false;
    }

    public boolean isDeactivate() {
        for (LifeEvent lifeEvent : this.lifeEvents) {
            if (lifeEvent.getType() != LifeEventType.DEACTIVATE) continue;
            return true;
        }
        return false;
    }

    public abstract boolean compatibleForCreate(Participant var1);
}

