/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandArrow
extends SingleLineCommand2<SequenceDiagram> {
    public CommandArrow(SequenceDiagram sequenceDiagram) {
        super(sequenceDiagram, CommandArrow.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr("PART1", new RegexLeaf("PART1CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("PART1LONG", "\"([^\"]+)\""), new RegexLeaf("PART1LONGCODE", "\"([^\"]+)\"\\s*as\\s+([\\p{L}0-9_.@]+)"), new RegexLeaf("PART1CODELONG", "([\\p{L}0-9_.@]+)\\s+as\\s*\"([^\"]+)\"")), new RegexLeaf("\\s*"), new RegexOr("ARROW", new RegexLeaf("ARROW_DIRECT", "( o)?[=-]+(>>?|//?|\\\\\\\\?|x )([ox] )?"), new RegexLeaf("ARROW_REVERSE", "( [xo])?( x|<<?|//?|\\\\\\\\?)[=-]+(o )?")), new RegexLeaf("\\s*"), new RegexOr("PART2", new RegexLeaf("PART2CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("PART2LONG", "\"([^\"]+)\""), new RegexLeaf("PART2LONGCODE", "\"([^\"]+)\"\\s*as\\s+([\\p{L}0-9_.@]+)"), new RegexLeaf("PART2CODELONG", "([\\p{L}0-9_.@]+)\\s+as\\s*\"([^\"]+)\"")), new RegexLeaf("\\s*"), new RegexLeaf("ACTIVATION", "(?:([+*!-]+)?)"), new RegexLeaf("\\s*"), new RegexLeaf("LIFECOLOR", "(?:(#\\w+)?)"), new RegexLeaf("\\s*"), new RegexLeaf("MESSAGE", "(?::\\s*(.*))?$"));
    }

    private Participant getOrCreateParticipant(RegexResult regexResult, String string) {
        List<String> list;
        String string2;
        if (regexResult.get(string + "CODE", 0) != null) {
            string2 = regexResult.get(string + "CODE", 0);
            list = StringUtils.getWithNewlines(string2);
        } else if (regexResult.get(string + "LONG", 0) != null) {
            string2 = regexResult.get(string + "LONG", 0);
            list = StringUtils.getWithNewlines(string2);
        } else if (regexResult.get(string + "LONGCODE", 0) != null) {
            list = StringUtils.getWithNewlines(regexResult.get(string + "LONGCODE", 0));
            string2 = regexResult.get(string + "LONGCODE", 1);
        } else {
            if (regexResult.get(string + "CODELONG", 0) != null) {
                String string3 = regexResult.get(string + "CODELONG", 0);
                List<String> list2 = StringUtils.getWithNewlines(regexResult.get(string + "CODELONG", 1));
                return ((SequenceDiagram)this.getSystem()).getOrCreateParticipant(string3, list2);
            }
            throw new IllegalStateException();
        }
        return ((SequenceDiagram)this.getSystem()).getOrCreateParticipant(string2, list);
    }

    private boolean decorationAtStart(RegexResult regexResult, String string) {
        return this.decorationAtPosition(regexResult, 0, 2, string);
    }

    private boolean decorationAtEnd(RegexResult regexResult, String string) {
        return this.decorationAtPosition(regexResult, 2, 0, string);
    }

    private boolean decorationAtPosition(RegexResult regexResult, int n, int n2, String string) {
        String string2 = regexResult.get("ARROW_DIRECT", n);
        if (string2 != null && string2.toLowerCase().contains(string)) {
            return true;
        }
        String string3 = regexResult.get("ARROW_REVERSE", n2);
        return string3 != null && string3.toLowerCase().contains(string);
    }

    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        String string;
        String string2;
        Participant participant;
        Participant participant2;
        boolean bl;
        String string3 = StringUtils.manageArrowForSequence(regexResult.get("ARROW", 0));
        String string4 = string3.replaceAll("[ o]", "");
        String string5 = string3.replaceAll("[ ox]", "");
        boolean bl2 = this.decorationAtStart(regexResult, "o");
        boolean bl3 = this.decorationAtEnd(regexResult, "o");
        boolean bl4 = bl = this.decorationAtEnd(regexResult, "x") || this.decorationAtPosition(regexResult, 1, 1, "x");
        if (string4.endsWith(">") || string4.endsWith("\\") || string4.endsWith("/") || string4.endsWith("x")) {
            participant2 = this.getOrCreateParticipant(regexResult, "PART1");
            participant = this.getOrCreateParticipant(regexResult, "PART2");
        } else if (string4.startsWith("x") || string4.startsWith("<") || string4.startsWith("\\") || string4.startsWith("/")) {
            participant = this.getOrCreateParticipant(regexResult, "PART1");
            participant2 = this.getOrCreateParticipant(regexResult, "PART2");
        } else {
            throw new IllegalStateException(string3);
        }
        boolean bl5 = string5.endsWith(">>") || string5.startsWith("<<") || string5.contains("\\\\") || string5.contains("//");
        boolean bl6 = string5.contains("--");
        List<String> list = regexResult.get("MESSAGE", 0) == null ? Arrays.asList("") : StringUtils.getWithNewlines(regexResult.get("MESSAGE", 0));
        ArrowConfiguration arrowConfiguration = ArrowConfiguration.withDirection(ArrowDirection.LEFT_TO_RIGHT_NORMAL);
        if (bl6) {
            arrowConfiguration = arrowConfiguration.withDotted();
        }
        if (bl5) {
            arrowConfiguration = arrowConfiguration.withHead(ArrowHead.ASYNC);
        }
        if (string5.endsWith("\\") || string5.startsWith("/")) {
            arrowConfiguration = arrowConfiguration.withPart(ArrowPart.TOP_PART);
        }
        if (string5.endsWith("/") || string5.startsWith("\\")) {
            arrowConfiguration = arrowConfiguration.withPart(ArrowPart.BOTTOM_PART);
        }
        if (bl3) {
            arrowConfiguration = arrowConfiguration.withDecorationEnd(ArrowDecoration.CIRCLE);
        }
        if (bl2) {
            arrowConfiguration = arrowConfiguration.withDecorationStart(ArrowDecoration.CIRCLE);
        }
        if (bl) {
            arrowConfiguration = arrowConfiguration.withDecorationEnd(ArrowDecoration.CROSSX);
        }
        if ((string2 = regexResult.get("ACTIVATION", 0)) != null && string2.charAt(0) == '*') {
            ((SequenceDiagram)this.getSystem()).activate(participant, LifeEventType.CREATE, null);
        }
        if ((string = ((SequenceDiagram)this.getSystem()).addMessage(new Message(participant2, participant, list, arrowConfiguration, ((SequenceDiagram)this.getSystem()).getNextMessageNumber()))) != null) {
            return CommandExecutionResult.error(string);
        }
        HtmlColor htmlColor = HtmlColorUtils.getColorIfValid(regexResult.get("LIFECOLOR", 0));
        if (string2 != null) {
            switch (string2.charAt(0)) {
                case '+': {
                    ((SequenceDiagram)this.getSystem()).activate(participant, LifeEventType.ACTIVATE, htmlColor);
                    break;
                }
                case '-': {
                    ((SequenceDiagram)this.getSystem()).activate(participant2, LifeEventType.DEACTIVATE, null);
                    break;
                }
                case '!': {
                    ((SequenceDiagram)this.getSystem()).activate(participant, LifeEventType.DESTROY, null);
                    break;
                }
            }
        } else if (((SequenceDiagram)this.getSystem()).isAutoactivate() && arrowConfiguration.getHead() == ArrowHead.NORMAL) {
            if (arrowConfiguration.isDotted()) {
                ((SequenceDiagram)this.getSystem()).activate(participant2, LifeEventType.DEACTIVATE, null);
            } else {
                ((SequenceDiagram)this.getSystem()).activate(participant, LifeEventType.ACTIVATE, htmlColor);
            }
        }
        return CommandExecutionResult.ok();
    }
}

