/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CommandExoArrowAny
extends SingleLineCommand<SequenceDiagram> {
    private final int posArrow;
    private final int posParticipant;

    public CommandExoArrowAny(SequenceDiagram sequenceDiagram, String string, int n, int n2) {
        super(sequenceDiagram, string);
        this.posArrow = n;
        this.posParticipant = n2;
    }

    @Override
    protected final CommandExecutionResult executeArg(List<String> list) {
        String string = StringUtils.manageArrowForSequence(list.get(this.posArrow));
        Participant participant = ((SequenceDiagram)this.getSystem()).getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(this.posParticipant)));
        boolean bl = string.contains(">>") || string.contains("<<") || string.contains("//") || string.contains("\\\\");
        boolean bl2 = string.contains("--");
        List<String> list2 = list.get(2) == null ? Arrays.asList("") : StringUtils.getWithNewlines(list.get(2));
        ArrowConfiguration arrowConfiguration = ArrowConfiguration.withDirection(ArrowDirection.LEFT_TO_RIGHT_NORMAL);
        if (bl2) {
            arrowConfiguration = arrowConfiguration.withDotted();
        }
        if (bl) {
            arrowConfiguration = arrowConfiguration.withHead(ArrowHead.ASYNC);
        }
        arrowConfiguration = arrowConfiguration.withPart(this.getArrowPart(string));
        String string2 = ((SequenceDiagram)this.getSystem()).addMessage(new MessageExo(participant, this.getMessageExoType(string), list2, arrowConfiguration, ((SequenceDiagram)this.getSystem()).getNextMessageNumber()));
        if (string2 != null) {
            return CommandExecutionResult.error(string2);
        }
        return CommandExecutionResult.ok();
    }

    private ArrowPart getArrowPart(String string) {
        if (string.contains("/")) {
            return ArrowPart.BOTTOM_PART;
        }
        if (string.contains("\\")) {
            return ArrowPart.TOP_PART;
        }
        return ArrowPart.FULL;
    }

    abstract MessageExoType getMessageExoType(String var1);
}

