/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandParticipant
extends SingleLineCommand2<SequenceDiagram> {
    public CommandParticipant(SequenceDiagram sequenceDiagram, RegexConcat regexConcat) {
        super(sequenceDiagram, regexConcat);
    }

    static IRegex getRegexType() {
        return new RegexOr(new RegexLeaf("TYPE", "(participant|actor|create|boundary|control|entity)"), new RegexLeaf("CREATE", "create (participant|actor|boundary|control|entity)"));
    }

    @Override
    protected final CommandExecutionResult executeArg(RegexResult regexResult) {
        String string;
        Object object;
        Object object2;
        boolean bl;
        ParticipantType participantType;
        String string2 = regexResult.get("CODE", 0);
        if (((SequenceDiagram)this.getSystem()).participants().containsKey(string2)) {
            ((SequenceDiagram)this.getSystem()).putParticipantInLast(string2);
            return CommandExecutionResult.ok();
        }
        List<String> list = null;
        if (regexResult.get("FULL", 0) != null) {
            list = StringUtils.getWithNewlines(regexResult.get("FULL", 0));
        }
        String string3 = regexResult.get("TYPE", 0);
        String string4 = regexResult.get("CREATE", 0);
        if (string4 != null) {
            participantType = ParticipantType.valueOf(string4.toUpperCase());
            bl = true;
        } else if (string3.equalsIgnoreCase("CREATE")) {
            participantType = ParticipantType.PARTICIPANT;
            bl = true;
        } else {
            participantType = ParticipantType.valueOf(string3.toUpperCase());
            bl = false;
        }
        Participant participant = ((SequenceDiagram)this.getSystem()).createNewParticipant(participantType, string2, list);
        String string5 = regexResult.get("STEREO", 0);
        if (string5 != null) {
            object2 = ((SequenceDiagram)this.getSystem()).getSkinParam();
            boolean bl2 = object2.stereotypePositionTop();
            object = object2.getFont(FontParam.CIRCLED_CHARACTER, null);
            participant.setStereotype(new Stereotype(string5, object2.getCircledCharacterRadius(), (UFont)object), bl2);
        }
        participant.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("COLOR", 0)));
        object2 = regexResult.get("URL", 0);
        if (object2 != null) {
            UrlBuilder urlBuilder = new UrlBuilder(((SequenceDiagram)this.getSystem()).getSkinParam().getValue("topurl"), true);
            object = urlBuilder.getUrl((String)object2);
            participant.setUrl((Url)object);
        }
        if (bl && (string = ((SequenceDiagram)this.getSystem()).activate(participant, LifeEventType.CREATE, null)) != null) {
            return CommandExecutionResult.error(string);
        }
        return CommandExecutionResult.ok();
    }
}

