/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandReferenceOverSeveral
extends SingleLineCommand2<SequenceDiagram> {
    public CommandReferenceOverSeveral(SequenceDiagram sequenceDiagram) {
        super(sequenceDiagram, CommandReferenceOverSeveral.getConcat());
    }

    private static RegexConcat getConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("REF", "ref(#\\w+)?\\s+over\\s+"), new RegexLeaf("PARTS", "(([\\p{L}0-9_.@]+|\"[^\"]+\")(\\s*,\\s*([\\p{L}0-9_.@]+|\"[^\"]+\"))*)"), new RegexLeaf("\\s*:\\s*"), new RegexLeaf("URL", "(?:\\[\\[([^|]*)(?:\\|([^|]*))?\\]\\])?"), new RegexLeaf("TEXT", "(.*)"), new RegexLeaf("$"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        void var9_12;
        HtmlColor htmlColor = HtmlColorUtils.getColorIfValid(regexResult.get("REF", 0));
        List<String> list = StringUtils.splitComma(regexResult.get("PARTS", 0));
        String string = regexResult.get("URL", 0);
        String string2 = regexResult.get("URL", 1);
        String string3 = regexResult.get("TEXT", 0).trim();
        ArrayList<Participant> arrayList = new ArrayList<Participant>();
        for (String object2 : list) {
            arrayList.add(((SequenceDiagram)this.getSystem()).getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(object2)));
        }
        List<String> list2 = StringUtils.getWithNewlines(string3);
        Object var9_10 = null;
        if (string != null) {
            Url url = new Url(string, string2);
        }
        HtmlColor htmlColor2 = null;
        Reference reference = new Reference(arrayList, (Url)var9_12, list2, htmlColor2, htmlColor);
        ((SequenceDiagram)this.getSystem()).addReference(reference);
        return CommandExecutionResult.ok();
    }
}

