/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.ParticipantEngloberContexted;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalNewpage;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeLine;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DrawableSet {
    private final Map<Participant, LivingParticipantBox> participants = new LinkedHashMap<Participant, LivingParticipantBox>();
    private final Map<Event, GraphicalElement> events = new HashMap<Event, GraphicalElement>();
    private final Map<Participant, ParticipantEnglober> participantEnglobers2 = new LinkedHashMap<Participant, ParticipantEnglober>();
    private final List<Event> eventsList = new ArrayList<Event>();
    private final Skin skin;
    private final ISkinParam skinParam;
    private Dimension2D dimension;
    private double topStartingY;
    private static final int MARGIN_FOR_ENGLOBERS = 4;
    private static final int MARGIN_FOR_ENGLOBERS1 = 2;

    DrawableSet(Skin skin, ISkinParam iSkinParam) {
        if (skin == null) {
            throw new IllegalArgumentException();
        }
        if (iSkinParam == null) {
            throw new IllegalArgumentException();
        }
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    public final Skin getSkin() {
        return this.skin;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public Collection<Event> getAllEvents() {
        return Collections.unmodifiableCollection(this.eventsList);
    }

    public Set<Participant> getAllParticipants() {
        return Collections.unmodifiableSet(this.participants.keySet());
    }

    public Collection<LivingParticipantBox> getAllLivingParticipantBox() {
        return Collections.unmodifiableCollection(this.participants.values());
    }

    public Collection<GraphicalElement> getAllGraphicalElements() {
        ArrayList<GraphicalElement> arrayList = new ArrayList<GraphicalElement>();
        for (Event event : this.eventsList) {
            arrayList.add(this.events.get(event));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public LivingParticipantBox getLivingParticipantBox(Participant participant) {
        return this.participants.get(participant);
    }

    public GraphicalElement getEvent(Event event) {
        return this.events.get(event);
    }

    public double getHeadHeight(StringBounder stringBounder) {
        double d = 0.0;
        for (Participant participant : this.participants.keySet()) {
            double d2 = this.getHeadAndEngloberHeight(participant, stringBounder);
            d = Math.max(d, d2);
        }
        return d;
    }

    public double getHeadAndEngloberHeight(Participant participant, StringBounder stringBounder) {
        LivingParticipantBox livingParticipantBox = this.participants.get(participant);
        double d = livingParticipantBox.getParticipantBox().getHeadHeight(stringBounder);
        ParticipantEngloberContexted participantEngloberContexted = this.getParticipantEnglober(participant);
        if (participantEngloberContexted == null) {
            return d;
        }
        Component component = this.skin.createComponent(ComponentType.ENGLOBER, null, this.skinParam, participantEngloberContexted.getParticipantEnglober().getTitle());
        double d2 = component.getPreferredHeight(stringBounder);
        return d + d2;
    }

    public List<ParticipantEngloberContexted> getExistingParticipantEnglober() {
        ArrayList<ParticipantEngloberContexted> arrayList = new ArrayList<ParticipantEngloberContexted>();
        ParticipantEngloberContexted participantEngloberContexted = null;
        for (Map.Entry<Participant, ParticipantEnglober> entry : this.participantEnglobers2.entrySet()) {
            ParticipantEnglober participantEnglober = entry.getValue();
            if (participantEnglober == null) {
                participantEngloberContexted = null;
                continue;
            }
            assert (participantEnglober != null);
            if (participantEngloberContexted != null && participantEnglober == participantEngloberContexted.getParticipantEnglober()) {
                participantEngloberContexted.add(entry.getKey());
                continue;
            }
            participantEngloberContexted = new ParticipantEngloberContexted(participantEnglober, entry.getKey());
            arrayList.add(participantEngloberContexted);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public double getOffsetForEnglobers(StringBounder stringBounder) {
        double d = 0.0;
        for (ParticipantEngloberContexted participantEngloberContexted : this.getExistingParticipantEnglober()) {
            Component component = this.skin.createComponent(ComponentType.ENGLOBER, null, this.skinParam, participantEngloberContexted.getParticipantEnglober().getTitle());
            double d2 = component.getPreferredHeight(stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getTailHeight(StringBounder stringBounder, boolean bl) {
        double d;
        double d2 = d = this.getExistingParticipantEnglober().size() > 0 ? 4.0 : 0.0;
        if (!bl) {
            return 1.0 + d;
        }
        double d3 = 0.0;
        for (LivingParticipantBox livingParticipantBox : this.participants.values()) {
            double d4 = livingParticipantBox.getParticipantBox().getTailHeight(stringBounder);
            d3 = Math.max(d3, d4);
        }
        return d3 + d;
    }

    public void addParticipant(Participant participant, ParticipantEnglober participantEnglober) {
        this.participants.put(participant, null);
        this.participantEnglobers2.put(participant, participantEnglober);
    }

    public void setLivingParticipantBox(Participant participant, LivingParticipantBox livingParticipantBox) {
        if (!this.participants.containsKey(participant)) {
            throw new IllegalArgumentException();
        }
        this.participants.put(participant, livingParticipantBox);
    }

    public void addEvent(Event event, GraphicalElement graphicalElement) {
        if (!this.events.keySet().contains(event)) {
            this.eventsList.add(event);
        }
        this.events.put(event, graphicalElement);
    }

    public void addEvent(Newpage newpage, GraphicalNewpage graphicalNewpage, Event event) {
        int n = this.eventsList.indexOf(event);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        this.eventsList.add(n, newpage);
        this.events.put(newpage, graphicalNewpage);
        assert (this.events.size() == this.eventsList.size());
    }

    void setDimension(Dimension2D dimension2D) {
        if (this.dimension != null) {
            throw new IllegalStateException();
        }
        this.dimension = dimension2D;
    }

    public Dimension2D getDimension() {
        return this.dimension;
    }

    void drawU(UGraphic uGraphic, double d, double d2, Page page, boolean bl) {
        double d3 = uGraphic.getTranslateX();
        double d4 = uGraphic.getTranslateY();
        int n = (int)page.getHeight();
        this.clipAndTranslate(d, d2, page, uGraphic);
        SimpleContext2D simpleContext2D = new SimpleContext2D(true);
        this.drawPlaygroundU(uGraphic, n, simpleContext2D);
        uGraphic.setClip(null);
        uGraphic.setTranslate(d3, d4);
        this.drawEnglobers(uGraphic, n - 2, simpleContext2D);
        this.drawLineU(uGraphic, bl, page);
        this.drawHeadTailU(uGraphic, page, bl ? (double)n - this.getTailHeight(uGraphic.getStringBounder(), true) : 0.0);
        this.clipAndTranslate(d, d2, page, uGraphic);
        this.drawPlaygroundU(uGraphic, n, new SimpleContext2D(false));
        uGraphic.setClip(null);
    }

    private void clipAndTranslate(double d, double d2, Page page, UGraphic uGraphic) {
        uGraphic.setClip(new UClip(0.0, page.getBodyRelativePosition(), d2, page.getBodyHeight() + 1.0));
        if (d > 0.0) {
            uGraphic.translate(0.0, -d);
        }
    }

    private void drawLineU(UGraphic uGraphic, boolean bl, Page page) {
        for (LivingParticipantBox livingParticipantBox : this.getAllLivingParticipantBox()) {
            double d = livingParticipantBox.getCreate();
            double d2 = page.getBodyRelativePosition() - livingParticipantBox.magicMargin(uGraphic.getStringBounder());
            double d3 = d2 + page.getBodyHeight() + 2.0 * livingParticipantBox.magicMargin(uGraphic.getStringBounder());
            double d4 = d2;
            if (d > 0.0) {
                if (d > page.getNewpage2()) continue;
                if (d >= page.getNewpage1() && d < page.getNewpage2()) {
                    d4 += d - page.getNewpage1() + 2.0 * livingParticipantBox.magicMargin(uGraphic.getStringBounder());
                }
            }
            livingParticipantBox.drawLineU(uGraphic, d4, d3, bl);
        }
    }

    private void drawHeadTailU(UGraphic uGraphic, Page page, double d) {
        for (Map.Entry<Participant, LivingParticipantBox> entry : this.participants.entrySet()) {
            Url url;
            Participant participant = entry.getKey();
            LivingParticipantBox livingParticipantBox = entry.getValue();
            double d2 = livingParticipantBox.getCreate();
            boolean bl = true;
            if (d2 > 0.0) {
                if (d2 > page.getNewpage2()) continue;
                if (d2 >= page.getNewpage1() && d2 < page.getNewpage2()) {
                    bl = false;
                }
            }
            if ((url = participant.getUrl()) != null) {
                uGraphic.startUrl(url);
            }
            livingParticipantBox.getParticipantBox().drawHeadTailU(uGraphic, this.topStartingY, bl, d);
            if (url == null) continue;
            uGraphic.closeAction();
        }
    }

    private double getMaxX() {
        return this.dimension.getWidth();
    }

    private double getMaxY() {
        return this.dimension.getHeight();
    }

    private void drawPlaygroundU(UGraphic uGraphic, double d, Context2D context2D) {
        for (Participant object : this.getAllParticipants()) {
            this.drawLifeLineU(uGraphic, object);
        }
        for (GraphicalElement graphicalElement : this.getAllGraphicalElements()) {
            graphicalElement.drawU(uGraphic, this.getMaxX(), context2D);
        }
    }

    private void drawEnglobers(UGraphic uGraphic, double d, Context2D context2D) {
        for (ParticipantEngloberContexted participantEngloberContexted : this.getExistingParticipantEnglober()) {
            Dimension2DDouble dimension2DDouble;
            double d2 = this.getX1(participantEngloberContexted);
            double d3 = this.getX2(uGraphic.getStringBounder(), participantEngloberContexted);
            Component component = this.getEngloberComponent(participantEngloberContexted.getParticipantEnglober());
            double d4 = d3 - d2;
            double d5 = this.getEngloberPreferedWidth(uGraphic.getStringBounder(), participantEngloberContexted.getParticipantEnglober());
            if (d5 > d4) {
                dimension2DDouble = new Dimension2DDouble(d5, d);
                uGraphic.translate(d2 -= (d5 - d4) / 2.0, 1.0);
                component.drawU(uGraphic, new Area(dimension2DDouble), context2D);
                uGraphic.translate(-d2, -1.0);
                continue;
            }
            dimension2DDouble = new Dimension2DDouble(d4, d);
            uGraphic.translate(d2, 1.0);
            component.drawU(uGraphic, new Area(dimension2DDouble), context2D);
            uGraphic.translate(-d2, -1.0);
        }
    }

    public double getEngloberPreferedWidth(StringBounder stringBounder, ParticipantEnglober participantEnglober) {
        return this.getEngloberComponent(participantEnglober).getPreferredWidth(stringBounder);
    }

    private Component getEngloberComponent(ParticipantEnglober participantEnglober) {
        ISkinParam iSkinParam = participantEnglober.getBoxColor() == null ? this.skinParam : new SkinParamBackcolored(this.skinParam, participantEnglober.getBoxColor());
        return this.skin.createComponent(ComponentType.ENGLOBER, null, iSkinParam, participantEnglober.getTitle());
    }

    public double getX1(ParticipantEngloberContexted participantEngloberContexted) {
        Participant participant = participantEngloberContexted.getFirst2();
        ParticipantBox participantBox = this.participants.get(participant).getParticipantBox();
        return participantBox.getStartingX() + 1.0;
    }

    public double getX2(StringBounder stringBounder, ParticipantEngloberContexted participantEngloberContexted) {
        Participant participant = participantEngloberContexted.getLast2();
        ParticipantBox participantBox = this.participants.get(participant).getParticipantBox();
        return participantBox.getMaxX(stringBounder) - 1.0;
    }

    private void drawLifeLineU(UGraphic uGraphic, Participant participant) {
        LifeLine lifeLine = this.getLivingParticipantBox(participant).getLifeLine();
        lifeLine.finish(this.getMaxY());
        lifeLine.drawU(uGraphic, this.getSkin(), this.skinParam);
    }

    private ParticipantEngloberContexted getParticipantEnglober(Participant participant) {
        for (ParticipantEngloberContexted participantEngloberContexted : this.getExistingParticipantEnglober()) {
            if (!participantEngloberContexted.contains(participant)) continue;
            return participantEngloberContexted;
        }
        return null;
    }

    public void setTopStartingY(double d) {
        this.topStartingY = d;
    }

    public void appendCmap(CMapData cMapData, int n, int n2, StringBounder stringBounder, SequenceDiagram sequenceDiagram) {
        double d;
        double d2;
        double d3;
        double d4;
        Object object;
        Url url;
        Object object2;
        for (Map.Entry<Participant, LivingParticipantBox> entry : this.participants.entrySet()) {
            object2 = entry.getKey();
            url = ((Participant)object2).getUrl();
            if (url == null) continue;
            object = entry.getValue().getParticipantBox();
            d4 = ((ParticipantBox)object).getPreferredWidth(stringBounder);
            d3 = ((ParticipantBox)object).getHeadHeightOnly(stringBounder);
            d2 = (double)n + ((ParticipantBox)object).getMinX();
            d = d2 + d4;
            double d5 = (double)n2 + this.topStartingY - ((ParticipantBox)object).magicMargin(stringBounder);
            double d6 = d5 - d3;
            String string = ((Participant)object2).getCode();
            this.appendArea(cMapData, string, url, d2, d, d5, d6);
        }
        for (Map.Entry<Object, Object> entry : this.events.entrySet()) {
            object2 = (Event)entry.getKey();
            url = object2.getUrl();
            if (url == null) continue;
            object = (GraphicalElement)entry.getValue();
            d4 = ((InGroupable)object).getMinX(stringBounder);
            d3 = ((InGroupable)object).getMaxX(stringBounder);
            d2 = ((GraphicalElement)object).getStartingY() + (double)n2;
            d = d2 + ((GraphicalElement)object).getPreferredHeight(stringBounder);
            this.appendArea(cMapData, object2.toString(), url, d4, d3, d, d2);
        }
    }

    private void appendArea(CMapData cMapData, String string, Url url, double d, double d2, double d3, double d4) {
        cMapData.appendString("<area shape=\"rect\" id=\"");
        cMapData.appendString(string);
        cMapData.appendString("\" href=\"");
        cMapData.appendString(url.getUrl());
        cMapData.appendString("\" title=\"");
        cMapData.appendString(url.getTooltip());
        cMapData.appendString("\" coords=\"");
        cMapData.appendLong(Math.round(d));
        cMapData.appendString(",");
        cMapData.appendLong(Math.round(d4));
        cMapData.appendString(",");
        cMapData.appendLong(Math.round(d2));
        cMapData.appendString(",");
        cMapData.appendLong(Math.round(d3));
        cMapData.appendString("\"/>\n");
    }

    Participant getFirst(Collection<Participant> collection) {
        ArrayList<Participant> arrayList = new ArrayList<Participant>(this.participants.keySet());
        int n = -1;
        for (Participant participant : collection) {
            int n2 = arrayList.indexOf(participant);
            assert (n2 != -1);
            if (n != -1 && n <= n2) continue;
            n = n2;
        }
        return (Participant)arrayList.get(n);
    }

    Participant getLast(Collection<Participant> collection) {
        ArrayList<Participant> arrayList = new ArrayList<Participant>(this.participants.keySet());
        int n = -1;
        for (Participant participant : collection) {
            int n2 = arrayList.indexOf(participant);
            assert (n2 != -1);
            if (n != -1 && n >= n2) continue;
            n = n2;
        }
        return (Participant)arrayList.get(n);
    }
}

