/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramInfo;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.VerticalPosition;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSetInitializer;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;
import net.sourceforge.plantuml.sequencediagram.graphic.PageSplitter;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramArea;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDiagramFileMaker
implements FileMaker {
    private static final StringBounder dummyStringBounder;
    private final SequenceDiagram diagram;
    private final DrawableSet drawableSet;
    private final Dimension2D fullDimension;
    private final List<Page> pages;
    private final FileFormatOption fileFormatOption;
    private final List<BufferedImage> flashcodes;
    private int offsetX;
    private int offsetY;

    public SequenceDiagramFileMaker(SequenceDiagram sequenceDiagram, Skin skin, FileFormatOption fileFormatOption, List<BufferedImage> list) {
        this.flashcodes = list;
        this.diagram = sequenceDiagram;
        this.fileFormatOption = fileFormatOption;
        DrawableSetInitializer drawableSetInitializer = new DrawableSetInitializer(skin, sequenceDiagram.getSkinParam(), sequenceDiagram.isShowFootbox(), sequenceDiagram.getAutonewpage());
        for (Participant object22 : sequenceDiagram.participants().values()) {
            drawableSetInitializer.addParticipant(object22, sequenceDiagram.getEnglober(object22));
        }
        for (Event event : sequenceDiagram.events()) {
            drawableSetInitializer.addEvent(event);
            if (!(event instanceof Message)) continue;
            Message message = (Message)event;
            for (LifeEvent lifeEvent : message.getLiveEvents()) {
                if (lifeEvent.getType() != LifeEventType.DESTROY) continue;
                drawableSetInitializer.addEvent(lifeEvent);
            }
        }
        this.drawableSet = drawableSetInitializer.createDrawableSet(dummyStringBounder);
        ArrayList arrayList = new ArrayList();
        for (Event event : this.drawableSet.getAllEvents()) {
            if (!(event instanceof Newpage)) continue;
            arrayList.add((Newpage)event);
        }
        this.fullDimension = this.drawableSet.getDimension();
        LinkedHashMap<Newpage, Double> linkedHashMap = new LinkedHashMap<Newpage, Double>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Newpage newpage = (Newpage)iterator.next();
            linkedHashMap.put(newpage, drawableSetInitializer.getYposition(dummyStringBounder, newpage));
        }
        this.pages = this.create(this.drawableSet, linkedHashMap, sequenceDiagram.isShowFootbox(), sequenceDiagram.getTitle()).getPages();
    }

    @Override
    public int getNbPages() {
        return this.pages.size();
    }

    private PageSplitter create(DrawableSet drawableSet, Map<Newpage, Double> map, boolean bl, List<? extends CharSequence> list) {
        double d = drawableSet.getHeadHeight(dummyStringBounder);
        double d2 = drawableSet.getTailHeight(dummyStringBounder, bl);
        double d3 = drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, null, drawableSet.getSkinParam(), Arrays.asList("")).getPreferredHeight(dummyStringBounder);
        return new PageSplitter(this.fullDimension.getHeight(), d, map, d2, 0.0, d3, list);
    }

    @Override
    public UmlDiagramInfo createOne2(OutputStream outputStream, int n) throws IOException {
        UGraphic uGraphic = this.createImage((int)this.fullDimension.getWidth(), this.pages.get(n), n);
        if (uGraphic instanceof UGraphicG2d) {
            BufferedImage bufferedImage = ((UGraphicG2d)uGraphic).getBufferedImage();
            PngIO.write((RenderedImage)bufferedImage, outputStream, this.diagram.getMetadata(), this.diagram.getDpi(this.fileFormatOption));
        } else if (uGraphic instanceof UGraphicSvg) {
            UGraphicSvg uGraphicSvg = (UGraphicSvg)uGraphic;
            uGraphicSvg.createXml(outputStream);
        } else if (uGraphic instanceof UGraphicEps) {
            UGraphicEps uGraphicEps = (UGraphicEps)uGraphic;
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else if (uGraphic instanceof UGraphicHtml5) {
            UGraphicHtml5 uGraphicHtml5 = (UGraphicHtml5)uGraphic;
            outputStream.write(uGraphicHtml5.generateHtmlCode().getBytes());
        }
        return new UmlDiagramInfo(this.fullDimension.getWidth());
    }

    private double getImageWidth(SequenceDiagramArea sequenceDiagramArea, boolean bl, double d) {
        int n = this.diagram.getMinwidth();
        double d2 = this.getImageWidthWithoutMinsize(sequenceDiagramArea, bl, d);
        if (n == Integer.MAX_VALUE) {
            return d2;
        }
        if (d2 >= (double)n) {
            return d2;
        }
        return n;
    }

    private double getScale(double d, double d2) {
        if (this.diagram.getScale() == null) {
            return 1.0;
        }
        return this.diagram.getScale().getScale(d, d2);
    }

    private double getImageWidthWithoutMinsize(SequenceDiagramArea sequenceDiagramArea, boolean bl, double d) {
        double d2 = bl ? sequenceDiagramArea.getHeight() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d : sequenceDiagramArea.getWidth() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d;
        return d2;
    }

    private double getImageHeight(SequenceDiagramArea sequenceDiagramArea, Page page, boolean bl, double d) {
        if (bl) {
            return sequenceDiagramArea.getWidth() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d;
        }
        return sequenceDiagramArea.getHeight() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d;
    }

    private UGraphic createImage(int n, Page page, int n2) {
        AbstractUGraphic abstractUGraphic;
        double d;
        double d2 = 0.0;
        if (n2 > 0) {
            d2 = page.getNewpage1() - page.getHeaderHeight();
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException();
        }
        SequenceDiagramArea sequenceDiagramArea = new SequenceDiagramArea(n, page.getHeight());
        Component component = null;
        if (page.getTitle() != null) {
            component = this.drawableSet.getSkin().createComponent(ComponentType.TITLE, null, this.drawableSet.getSkinParam(), page.getTitle());
            sequenceDiagramArea.setTitleArea(component.getPreferredWidth(dummyStringBounder), component.getPreferredHeight(dummyStringBounder));
        }
        this.addFooter2(sequenceDiagramArea);
        this.addHeader2(sequenceDiagramArea);
        this.offsetX = (int)Math.round(sequenceDiagramArea.getSequenceAreaX());
        this.offsetY = (int)Math.round(sequenceDiagramArea.getSequenceAreaY());
        Color color = null;
        if (this.diagram.getSkinParam().getBackgroundColor() instanceof HtmlColorSimple) {
            color = this.diagram.getSkinParam().getColorMapper().getMappedColor(this.diagram.getSkinParam().getBackgroundColor());
        }
        FileFormat fileFormat = this.fileFormatOption.getFileFormat();
        double d3 = this.diagram.getDpiFactor(this.fileFormatOption);
        double d4 = this.getImageWidth(sequenceDiagramArea, this.diagram.isRotation(), d3);
        if (fileFormat == FileFormat.PNG) {
            AffineTransform affineTransform;
            double d5 = this.getImageHeight(sequenceDiagramArea, page, this.diagram.isRotation(), d3);
            if (d5 == 0.0) {
                d5 = 1.0;
            }
            d = 0.0;
            if (this.flashcodes != null) {
                d = this.flashcodes.get(0).getHeight();
            }
            EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(d4, d5 + d, color);
            Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
            if (this.flashcodes != null) {
                graphics2D.drawImage(this.flashcodes.get(0), null, 0, (int)d5);
            }
            if (this.diagram.isRotation()) {
                affineTransform = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                affineTransform.concatenate(new AffineTransform(-1.0, 0.0, 0.0, 1.0, d5, 0.0));
                affineTransform.concatenate(AffineTransform.getTranslateInstance(0.01, 0.0));
                graphics2D.setTransform(affineTransform);
            }
            affineTransform = graphics2D.getTransform();
            affineTransform.scale(this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()), this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()));
            graphics2D.setTransform(affineTransform);
            abstractUGraphic = new UGraphicG2d(this.diagram.getSkinParam().getColorMapper(), graphics2D, emptyImageBuilder.getBufferedImage(), d3, this.fileFormatOption.getAffineTransform());
            if (this.diagram.getSkinParam().getBackgroundColor() instanceof HtmlColorGradient) {
                BufferedImage bufferedImage = ((UGraphicG2d)abstractUGraphic).getBufferedImage();
                abstractUGraphic.getParam().setBackcolor(this.diagram.getSkinParam().getBackgroundColor());
                abstractUGraphic.draw(0.0, 0.0, new URectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
                abstractUGraphic.getParam().setBackcolor(null);
            }
        } else if (fileFormat == FileFormat.SVG) {
            abstractUGraphic = this.diagram.getSkinParam().getBackgroundColor() instanceof HtmlColorGradient ? new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), (HtmlColorGradient)this.diagram.getSkinParam().getBackgroundColor(), false) : (color == null || color.equals(Color.WHITE) ? new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), false) : new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), StringUtils.getAsHtml(color), false));
        } else if (fileFormat == FileFormat.EPS) {
            abstractUGraphic = new UGraphicEps(this.diagram.getSkinParam().getColorMapper(), EpsStrategy.getDefault2());
        } else if (fileFormat == FileFormat.EPS_TEXT) {
            abstractUGraphic = new UGraphicEps(this.diagram.getSkinParam().getColorMapper(), EpsStrategy.WITH_MACRO_AND_TEXT);
        } else if (fileFormat == FileFormat.HTML5) {
            abstractUGraphic = new UGraphicHtml5(this.diagram.getSkinParam().getColorMapper());
        } else {
            throw new UnsupportedOperationException();
        }
        int n3 = (int)Math.round((d4 - this.getImageWidthWithoutMinsize(sequenceDiagramArea, this.diagram.isRotation(), d3)) / 2.0);
        if (this.diagram.isRotation()) {
            abstractUGraphic.translate(0.0, (double)n3 / d3);
        } else {
            abstractUGraphic.translate((double)n3 / d3, 0.0);
        }
        if (component != null) {
            abstractUGraphic.translate(sequenceDiagramArea.getTitleX(), sequenceDiagramArea.getTitleY());
            StringBounder stringBounder = abstractUGraphic.getStringBounder();
            d = component.getPreferredHeight(stringBounder);
            double d6 = component.getPreferredWidth(stringBounder);
            component.drawU(abstractUGraphic, new Area(new Dimension2DDouble(d6, d)), new SimpleContext2D(false));
            abstractUGraphic.translate(-sequenceDiagramArea.getTitleX(), -sequenceDiagramArea.getTitleY());
        }
        this.addHeader3(sequenceDiagramArea, abstractUGraphic);
        this.addFooter3(sequenceDiagramArea, abstractUGraphic);
        abstractUGraphic.translate(sequenceDiagramArea.getSequenceAreaX(), sequenceDiagramArea.getSequenceAreaY());
        this.drawableSet.drawU(abstractUGraphic, d2, n, page, this.diagram.isShowFootbox());
        return abstractUGraphic;
    }

    private void addFooter2(SequenceDiagramArea sequenceDiagramArea) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getSize();
        PngTitler pngTitler = new PngTitler(this.diagram.getSkinParam().getColorMapper(), htmlColor, this.diagram.getFooter(), n, string, this.diagram.getFooterAlignement(), VerticalPosition.BOTTOM);
        Dimension2D dimension2D = pngTitler.getTextDimension(dummyStringBounder);
        if (dimension2D != null) {
            sequenceDiagramArea.setFooterArea(dimension2D.getWidth(), dimension2D.getHeight(), 3.0);
        }
    }

    private void addHeader2(SequenceDiagramArea sequenceDiagramArea) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getSize();
        PngTitler pngTitler = new PngTitler(this.diagram.getSkinParam().getColorMapper(), htmlColor, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignement(), VerticalPosition.TOP);
        Dimension2D dimension2D = pngTitler.getTextDimension(dummyStringBounder);
        if (dimension2D != null) {
            sequenceDiagramArea.setHeaderArea(dimension2D.getWidth(), dimension2D.getHeight(), 3.0);
        }
    }

    private void addFooter3(SequenceDiagramArea sequenceDiagramArea, UGraphic uGraphic) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null).getSize();
        PngTitler pngTitler = new PngTitler(this.diagram.getSkinParam().getColorMapper(), htmlColor, this.diagram.getFooter(), n, string, this.diagram.getFooterAlignement(), VerticalPosition.BOTTOM);
        TextBlock textBlock = pngTitler.getTextBlock();
        if (textBlock == null) {
            return;
        }
        textBlock.drawU(uGraphic, sequenceDiagramArea.getFooterX(this.diagram.getFooterAlignement()), sequenceDiagramArea.getFooterY());
    }

    private void addHeader3(SequenceDiagramArea sequenceDiagramArea, UGraphic uGraphic) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.HEADER, null).getSize();
        PngTitler pngTitler = new PngTitler(this.diagram.getSkinParam().getColorMapper(), htmlColor, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignement(), VerticalPosition.TOP);
        TextBlock textBlock = pngTitler.getTextBlock();
        if (textBlock == null) {
            return;
        }
        textBlock.drawU(uGraphic, sequenceDiagramArea.getHeaderX(this.diagram.getHeaderAlignement()), sequenceDiagramArea.getHeaderY());
    }

    public static StringBounder getDummystringbounder() {
        return dummyStringBounder;
    }

    @Override
    public void appendCmap(CMapData cMapData) {
        this.drawableSet.appendCmap(cMapData, this.offsetX, this.offsetY, dummyStringBounder, this.diagram);
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        dummyStringBounder = StringBounderUtils.asStringBounder(bufferedImage.createGraphics());
    }
}

