/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.skin.ArrowBody;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

public class ArrowConfiguration {
    private final ArrowDirection direction;
    private final ArrowBody body;
    private final ArrowHead head;
    private final ArrowPart part;
    private final ArrowDecoration decorationStart;
    private final ArrowDecoration decorationEnd;

    private ArrowConfiguration(ArrowDirection arrowDirection, ArrowBody arrowBody, ArrowHead arrowHead, ArrowPart arrowPart, ArrowDecoration arrowDecoration, ArrowDecoration arrowDecoration2) {
        if (arrowDirection == null || arrowBody == null || arrowHead == null || arrowPart == null) {
            throw new IllegalArgumentException();
        }
        this.part = arrowPart;
        this.direction = arrowDirection;
        this.body = arrowBody;
        this.head = arrowHead;
        this.decorationStart = arrowDecoration;
        this.decorationEnd = arrowDecoration2;
    }

    public String toString() {
        return this.name();
    }

    public String name() {
        return this.direction.name().substring(0, 4) + "-" + this.body.name() + "-" + this.head.name() + "-" + this.part.name().substring(0, 3) + "-" + this.decorationEnd.name().substring(0, 4);
    }

    public static ArrowConfiguration withDirection(ArrowDirection arrowDirection) {
        return new ArrowConfiguration(arrowDirection, ArrowBody.NORMAL, ArrowHead.NORMAL, ArrowPart.FULL, ArrowDecoration.NONE, ArrowDecoration.NONE);
    }

    public ArrowConfiguration reverse() {
        if (this.direction == ArrowDirection.SELF) {
            throw new UnsupportedOperationException();
        }
        return new ArrowConfiguration(this.direction.reverse(), this.body, this.head, this.part, this.decorationStart, this.decorationEnd);
    }

    public ArrowConfiguration withHead(ArrowHead arrowHead) {
        return new ArrowConfiguration(this.direction, this.body, arrowHead, this.part, this.decorationStart, this.decorationEnd);
    }

    public ArrowConfiguration withDotted() {
        return new ArrowConfiguration(this.direction, ArrowBody.DOTTED, this.head, this.part, this.decorationStart, this.decorationEnd);
    }

    public ArrowConfiguration withPart(ArrowPart arrowPart) {
        return new ArrowConfiguration(this.direction, this.body, this.head, arrowPart, this.decorationStart, this.decorationEnd);
    }

    public ArrowConfiguration withDecorationStart(ArrowDecoration arrowDecoration) {
        return new ArrowConfiguration(this.direction, this.body, this.head, this.part, arrowDecoration, this.decorationEnd);
    }

    public ArrowConfiguration withDecorationEnd(ArrowDecoration arrowDecoration) {
        return new ArrowConfiguration(this.direction, this.body, this.head, this.part, this.decorationStart, arrowDecoration);
    }

    public final ArrowDecoration getDecorationEnd() {
        return this.decorationEnd;
    }

    public final ArrowDecoration getDecorationStart() {
        return this.decorationStart;
    }

    public boolean isLeftToRightNormal() {
        return this.direction == ArrowDirection.LEFT_TO_RIGHT_NORMAL;
    }

    public boolean isRightToLeftReverse() {
        return this.direction == ArrowDirection.RIGHT_TO_LEFT_REVERSE;
    }

    public boolean isSelfArrow() {
        return this.direction == ArrowDirection.SELF;
    }

    public boolean isDotted() {
        return this.body == ArrowBody.DOTTED;
    }

    public ArrowHead getHead() {
        return this.head;
    }

    public final ArrowPart getPart() {
        return this.part;
    }
}

