/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.bluemodern.AbstractComponentBlueModernArrow;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBlueModernArrow
extends AbstractComponentBlueModernArrow {
    public ComponentBlueModernArrow(HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, List<? extends CharSequence> list, ArrowConfiguration arrowConfiguration, SpriteContainer spriteContainer) {
        super(htmlColor, htmlColor2, uFont, list, arrowConfiguration, spriteContainer);
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        uGraphic.getParam().setColor(this.getForegroundColor());
        uGraphic.getParam().setBackcolor(this.getForegroundColor());
        int n2 = (int)dimension2D.getWidth();
        if (this.getArrowConfiguration().isDotted()) {
            this.stroke(uGraphic, 5.0, 2.0);
        } else {
            uGraphic.getParam().setStroke(new UStroke(2.0));
        }
        uGraphic.draw(2.0, n, new ULine(n2 - 4, 0.0));
        uGraphic.getParam().setStroke(new UStroke());
        int n3 = this.getDirection();
        UPolygon uPolygon = new UPolygon();
        if (this.getArrowConfiguration().getHead() == ArrowHead.ASYNC) {
            uGraphic.getParam().setStroke(new UStroke(1.5));
            if (n3 == 1) {
                if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                    uGraphic.draw(n2 - this.getArrowDeltaX2(), n - this.getArrowDeltaY2(), new ULine(this.getArrowDeltaX2(), this.getArrowDeltaY2()));
                }
                if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                    uGraphic.draw(n2 - this.getArrowDeltaX2(), n + this.getArrowDeltaY2(), new ULine(this.getArrowDeltaX2(), -this.getArrowDeltaY2()));
                }
            } else {
                if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                    uGraphic.draw(this.getArrowDeltaX2(), n - this.getArrowDeltaY2(), new ULine(-this.getArrowDeltaX2(), this.getArrowDeltaY2()));
                }
                if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                    uGraphic.draw(this.getArrowDeltaX2(), n + this.getArrowDeltaY2(), new ULine(-this.getArrowDeltaX2(), -this.getArrowDeltaY2()));
                }
            }
            uGraphic.getParam().setStroke(new UStroke());
        } else if (n3 == 1) {
            this.createPolygonNormal(n, n2, uPolygon);
        } else {
            this.createPolygonReverse(n, uPolygon);
        }
        uGraphic.draw(0.0, 0.0, uPolygon);
        this.getTextBlock().drawU(uGraphic, this.getMarginX1(), 0.0);
    }

    private void createPolygonReverse(int n, UPolygon uPolygon) {
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n);
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY());
        } else {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY());
        }
    }

    private void createPolygonNormal(int n, int n2, UPolygon uPolygon) {
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(n2, n);
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n);
            uPolygon.addPoint(n2, n);
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n + this.getArrowDeltaY());
        } else {
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(n2, n);
            uPolygon.addPoint(n2 - this.getArrowDeltaX(), n + this.getArrowDeltaY());
        }
    }

    protected int getDirection(Graphics2D graphics2D) {
        return this.getDirection();
    }

    protected int getDirection() {
        if (this.getArrowConfiguration().isLeftToRightNormal()) {
            return 1;
        }
        if (this.getArrowConfiguration().isRightToLeftReverse()) {
            return -1;
        }
        throw new IllegalStateException();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + 2.0 * this.getPaddingY();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

