/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.bluemodern.FillRoundShape;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBlueModernDivider
extends AbstractTextualComponent {
    private final HtmlColor background1;
    private final HtmlColor background2;
    private final HtmlColor borderColor;

    public ComponentBlueModernDivider(HtmlColor htmlColor, UFont uFont, HtmlColor htmlColor2, HtmlColor htmlColor3, HtmlColor htmlColor4, List<? extends CharSequence> list, SpriteContainer spriteContainer) {
        super(list, htmlColor, uFont, HorizontalAlignement.CENTER, 4, 4, 4, spriteContainer);
        this.background1 = htmlColor2;
        this.background2 = htmlColor3;
        this.borderColor = htmlColor4;
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getTextWidth(stringBounder);
        double d2 = this.getTextHeight(stringBounder);
        double d3 = (dimension2D.getWidth() - d - 6.0) / 2.0;
        double d4 = (dimension2D.getHeight() - d2) / 2.0;
        uGraphic.getParam().setColor(HtmlColorUtils.BLACK);
        uGraphic.getParam().setBackcolor(HtmlColorUtils.BLACK);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(0.0, dimension2D.getHeight() / 2.0 - 1.0, new ULine(dimension2D.getWidth(), 0.0));
        uGraphic.draw(0.0, dimension2D.getHeight() / 2.0 + 2.0, new ULine(dimension2D.getWidth(), 0.0));
        FillRoundShape fillRoundShape = new FillRoundShape(d + 6.0, d2, this.background1, this.background2, 5.0);
        uGraphic.translate(d3, d4);
        fillRoundShape.drawU(uGraphic);
        uGraphic.translate(-d3, -d4);
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(null);
        uGraphic.draw(d3, d4, new URectangle(d + 6.0, d2, 5.0, 5.0));
        uGraphic.getParam().setStroke(new UStroke());
        textBlock.drawU(uGraphic, d3 + 6.0, d4 + (double)this.getMarginY());
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 30.0;
    }
}

