/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBlueModernEnglober
extends AbstractTextualComponent {
    private final HtmlColor borderColor;
    private final HtmlColor backColor;

    public ComponentBlueModernEnglober(HtmlColor htmlColor, HtmlColor htmlColor2, List<? extends CharSequence> list, HtmlColor htmlColor3, UFont uFont, SpriteContainer spriteContainer) {
        super(list, htmlColor3, uFont, HorizontalAlignement.CENTER, 4, 4, 1, spriteContainer);
        this.borderColor = htmlColor;
        this.backColor = htmlColor2;
    }

    @Override
    protected void drawBackgroundInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic.getParam().setColor(this.borderColor);
        uGraphic.getParam().setBackcolor(this.backColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(0.0, 0.0, new URectangle(dimension2D.getWidth(), dimension2D.getHeight(), 9.0, 9.0));
        double d = (dimension2D.getWidth() - this.getPureTextWidth(uGraphic.getStringBounder())) / 2.0;
        uGraphic.getParam().setStroke(new UStroke());
        this.getTextBlock().drawU(uGraphic, d, 0.0);
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Area area) {
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 3.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 10.0;
    }
}

