/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.util.List;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.bluemodern.ShadowShape;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentBlueModernNote
extends AbstractTextualComponent {
    private final int shadowview = 4;
    private final int cornersize = 10;
    private final HtmlColor back;
    private final HtmlColor foregroundColor;

    public ComponentBlueModernNote(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UFont uFont, List<? extends CharSequence> list, SpriteContainer spriteContainer) {
        super(list, htmlColor3, uFont, HorizontalAlignement.LEFT, 6, 15, 5, spriteContainer);
        this.back = htmlColor;
        this.foregroundColor = htmlColor2;
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double d = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX();
        return d;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    @Override
    public double getPaddingX() {
        return 9.0;
    }

    @Override
    public double getPaddingY() {
        return 9.0;
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getTextHeight(stringBounder);
        double d2 = this.getTextWidth(stringBounder);
        ShadowShape shadowShape = new ShadowShape(d2, d, 3.0);
        uGraphic.translate(4.0, 4.0);
        shadowShape.drawU(uGraphic);
        uGraphic.translate(-4.0, -4.0);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, d);
        uPolygon.addPoint(d2, d);
        uPolygon.addPoint(d2, 10.0);
        uPolygon.addPoint(d2 - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        uGraphic.getParam().setBackcolor(this.back);
        uGraphic.getParam().setColor(this.foregroundColor);
        uGraphic.draw(0.0, 0.0, uPolygon);
        uGraphic.draw(d2 - 10.0, 0.0, new ULine(0.0, 10.0));
        uGraphic.draw(d2, 10.0, new ULine(-10.0, 0.0));
        this.getTextBlock().drawU(uGraphic, this.getMarginX1(), this.getMarginY());
    }
}

