/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.util.List;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRoseParticipant
extends AbstractTextualComponent {
    private final HtmlColor back;
    private final HtmlColor foregroundColor;
    private final double deltaShadow;
    private final double roundCorner;

    public ComponentRoseParticipant(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UFont uFont, List<? extends CharSequence> list, SpriteContainer spriteContainer, double d, double d2) {
        super(list, htmlColor3, uFont, HorizontalAlignement.CENTER, 7, 7, 7, spriteContainer);
        this.back = htmlColor;
        this.roundCorner = d2;
        this.deltaShadow = d;
        this.foregroundColor = htmlColor2;
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.getParam().setColor(this.foregroundColor);
        uGraphic.getParam().setBackcolor(this.back);
        uGraphic.getParam().setStroke(new UStroke(1.5));
        URectangle uRectangle = new URectangle(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), this.roundCorner, this.roundCorner);
        uRectangle.setDeltaShadow(this.deltaShadow);
        uGraphic.draw(0.0, 0.0, uRectangle);
        uGraphic.getParam().setStroke(new UStroke());
        TextBlock textBlock = this.getTextBlock();
        textBlock.drawU(uGraphic, this.getMarginX1(), this.getMarginY());
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + this.deltaShadow + 1.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + this.deltaShadow;
    }
}

