/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActiveLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActor;
import net.sourceforge.plantuml.skin.rose.ComponentRoseArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseBoundary;
import net.sourceforge.plantuml.skin.rose.ComponentRoseControl;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayText;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDestroy;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDivider;
import net.sourceforge.plantuml.skin.rose.ComponentRoseEnglober;
import net.sourceforge.plantuml.skin.rose.ComponentRoseEntity;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingElse;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingHeader;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingSpace;
import net.sourceforge.plantuml.skin.rose.ComponentRoseLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNewpage;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNote;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNoteBox;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNoteHexagonal;
import net.sourceforge.plantuml.skin.rose.ComponentRoseParticipant;
import net.sourceforge.plantuml.skin.rose.ComponentRoseReference;
import net.sourceforge.plantuml.skin.rose.ComponentRoseSelfArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseTitle;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rose
implements Skin {
    private final Map<ColorParam, HtmlColor> defaultsColor = new EnumMap<ColorParam, HtmlColor>(ColorParam.class);
    private double paddingX = 5.0;
    private double paddingY = 5.0;

    public void setPaddingNote(double d, double d2) {
        this.paddingX = d;
        this.paddingY = d2;
    }

    public Rose() {
        this.defaultsColor.put(ColorParam.background, HtmlColorUtils.getColorIfValid("white"));
        this.defaultsColor.put(ColorParam.sequenceArrow, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.usecaseArrow, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.classArrow, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.objectArrow, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.activityArrow, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.componentArrow, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.stateArrow, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.sequenceLifeLineBackground, HtmlColorUtils.getColorIfValid("white"));
        this.defaultsColor.put(ColorParam.sequenceLifeLineBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.sequenceGroupBackground, HtmlColorUtils.getColorIfValid("#EEEEEE"));
        this.defaultsColor.put(ColorParam.sequenceGroupBorder, HtmlColorUtils.BLACK);
        this.defaultsColor.put(ColorParam.sequenceDividerBackground, HtmlColorUtils.getColorIfValid("#EEEEEE"));
        this.defaultsColor.put(ColorParam.sequenceReferenceBorder, HtmlColorUtils.BLACK);
        this.defaultsColor.put(ColorParam.sequenceReferenceBackground, HtmlColorUtils.getColorIfValid("white"));
        this.defaultsColor.put(ColorParam.sequenceReferenceHeaderBackground, HtmlColorUtils.getColorIfValid("#EEEEEE"));
        this.defaultsColor.put(ColorParam.sequenceBoxBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.sequenceBoxBackground, HtmlColorUtils.getColorIfValid("#DDDDDD"));
        this.defaultsColor.put(ColorParam.noteBackground, HtmlColorUtils.getColorIfValid("#FBFB77"));
        this.defaultsColor.put(ColorParam.noteBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.activityBackground, HtmlColorUtils.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.activityBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.activityStart, HtmlColorUtils.BLACK);
        this.defaultsColor.put(ColorParam.activityEnd, HtmlColorUtils.BLACK);
        this.defaultsColor.put(ColorParam.activityBar, HtmlColorUtils.BLACK);
        this.defaultsColor.put(ColorParam.stateBackground, HtmlColorUtils.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.stateBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.stateStart, HtmlColorUtils.BLACK);
        this.defaultsColor.put(ColorParam.stateEnd, HtmlColorUtils.BLACK);
        this.defaultsColor.put(ColorParam.usecaseBackground, HtmlColorUtils.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.usecaseBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.componentBackground, HtmlColorUtils.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.componentBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.componentInterfaceBackground, HtmlColorUtils.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.componentInterfaceBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.usecaseActorBackground, HtmlColorUtils.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.usecaseActorBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.sequenceActorBackground, HtmlColorUtils.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.sequenceActorBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.sequenceParticipantBackground, HtmlColorUtils.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.sequenceParticipantBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.classBackground, HtmlColorUtils.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.classBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.objectBackground, HtmlColorUtils.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.objectBorder, HtmlColorUtils.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.stereotypeCBackground, HtmlColorUtils.getColorIfValid("#ADD1B2"));
        this.defaultsColor.put(ColorParam.stereotypeABackground, HtmlColorUtils.getColorIfValid("#A9DCDF"));
        this.defaultsColor.put(ColorParam.stereotypeIBackground, HtmlColorUtils.getColorIfValid("#B4A7E5"));
        this.defaultsColor.put(ColorParam.stereotypeEBackground, HtmlColorUtils.getColorIfValid("#EB937F"));
        this.defaultsColor.put(ColorParam.packageBackground, HtmlColorUtils.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.packageBorder, HtmlColorUtils.BLACK);
        this.defaultsColor.put(ColorParam.iconPrivate, HtmlColorUtils.getColorIfValid("#C82930"));
        this.defaultsColor.put(ColorParam.iconPrivateBackground, HtmlColorUtils.getColorIfValid("#F24D5C"));
        this.defaultsColor.put(ColorParam.iconProtected, HtmlColorUtils.getColorIfValid("#B38D22"));
        this.defaultsColor.put(ColorParam.iconProtectedBackground, HtmlColorUtils.getColorIfValid("#FFFF44"));
        this.defaultsColor.put(ColorParam.iconPackage, HtmlColorUtils.getColorIfValid("#1963A0"));
        this.defaultsColor.put(ColorParam.iconPackageBackground, HtmlColorUtils.getColorIfValid("#4177AF"));
        this.defaultsColor.put(ColorParam.iconPublic, HtmlColorUtils.getColorIfValid("#038048"));
        this.defaultsColor.put(ColorParam.iconPublicBackground, HtmlColorUtils.getColorIfValid("#84BE84"));
    }

    public HtmlColor getFontColor(ISkinParam iSkinParam, FontParam fontParam) {
        return iSkinParam.getFontHtmlColor(fontParam, null);
    }

    public HtmlColor getHtmlColor(ISkinParam iSkinParam, ColorParam colorParam) {
        return this.getHtmlColor(iSkinParam, colorParam, null);
    }

    public HtmlColor getHtmlColor(ISkinParam iSkinParam, ColorParam colorParam, String string) {
        HtmlColor htmlColor = iSkinParam.getHtmlColor(colorParam, string, false);
        if (htmlColor == null && (htmlColor = this.defaultsColor.get((Object)colorParam)) == null) {
            throw new IllegalArgumentException();
        }
        return htmlColor;
    }

    @Override
    public Component createComponent(ComponentType componentType, ArrowConfiguration arrowConfiguration, ISkinParam iSkinParam, List<? extends CharSequence> list) {
        double d;
        HtmlColor htmlColor = iSkinParam.getBackgroundColor();
        HtmlColor htmlColor2 = this.getHtmlColor(iSkinParam, ColorParam.sequenceGroupBorder);
        HtmlColor htmlColor3 = this.getHtmlColor(iSkinParam, ColorParam.sequenceGroupBackground);
        HtmlColor htmlColor4 = this.getHtmlColor(iSkinParam, ColorParam.sequenceDividerBackground);
        HtmlColor htmlColor5 = this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceBackground);
        HtmlColor htmlColor6 = this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceHeaderBackground);
        HtmlColor htmlColor7 = this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceBorder);
        HtmlColor htmlColor8 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBackground);
        HtmlColor htmlColor9 = this.getHtmlColor(iSkinParam, ColorParam.sequenceArrow);
        HtmlColor htmlColor10 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBackground);
        HtmlColor htmlColor11 = this.getHtmlColor(iSkinParam, ColorParam.sequenceParticipantBackground);
        UFont uFont = iSkinParam.getFont(FontParam.SEQUENCE_ARROW, null);
        UFont uFont2 = iSkinParam.getFont(FontParam.SEQUENCE_GROUP, null);
        UFont uFont3 = iSkinParam.getFont(FontParam.SEQUENCE_PARTICIPANT, null);
        UFont uFont4 = iSkinParam.getFont(FontParam.SEQUENCE_ACTOR, null);
        double d2 = d = iSkinParam.shadowing() ? 4.0 : 0.0;
        if (componentType.isArrow()) {
            if (arrowConfiguration.isSelfArrow()) {
                return new ComponentRoseSelfArrow(htmlColor9, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ARROW), uFont, list, arrowConfiguration, iSkinParam);
            }
            return new ComponentRoseArrow(htmlColor9, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ARROW), uFont, list, arrowConfiguration, iSkinParam.getHorizontalAlignement(AlignParam.SEQUENCE_MESSAGE_ALIGN), iSkinParam);
        }
        if (componentType == ComponentType.PARTICIPANT_HEAD) {
            HtmlColor htmlColor12 = this.getHtmlColor(iSkinParam, ColorParam.sequenceParticipantBorder);
            return new ComponentRoseParticipant(htmlColor11, htmlColor12, this.getFontColor(iSkinParam, FontParam.SEQUENCE_PARTICIPANT), uFont3, list, iSkinParam, d, iSkinParam.getRoundCorner());
        }
        if (componentType == ComponentType.PARTICIPANT_TAIL) {
            HtmlColor htmlColor13 = this.getHtmlColor(iSkinParam, ColorParam.sequenceParticipantBorder);
            return new ComponentRoseParticipant(htmlColor11, htmlColor13, this.getFontColor(iSkinParam, FontParam.SEQUENCE_PARTICIPANT), uFont3, list, iSkinParam, d, iSkinParam.getRoundCorner());
        }
        if (componentType == ComponentType.PARTICIPANT_LINE) {
            HtmlColor htmlColor14 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(htmlColor14, false);
        }
        if (componentType == ComponentType.CONTINUE_LINE) {
            HtmlColor htmlColor15 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(htmlColor15, true);
        }
        if (componentType == ComponentType.ACTOR_HEAD) {
            HtmlColor htmlColor16 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBorder);
            return new ComponentRoseActor(htmlColor10, htmlColor16, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ACTOR), uFont4, list, true, iSkinParam, d);
        }
        if (componentType == ComponentType.ACTOR_TAIL) {
            HtmlColor htmlColor17 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBorder);
            return new ComponentRoseActor(htmlColor10, htmlColor17, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ACTOR), uFont4, list, false, iSkinParam, d);
        }
        if (componentType == ComponentType.BOUNDARY_HEAD) {
            HtmlColor htmlColor18 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBorder);
            return new ComponentRoseBoundary(htmlColor10, htmlColor18, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ACTOR), uFont4, list, true, iSkinParam, d);
        }
        if (componentType == ComponentType.BOUNDARY_TAIL) {
            HtmlColor htmlColor19 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBorder);
            return new ComponentRoseBoundary(htmlColor10, htmlColor19, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ACTOR), uFont4, list, false, iSkinParam, d);
        }
        if (componentType == ComponentType.CONTROL_HEAD) {
            HtmlColor htmlColor20 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBorder);
            return new ComponentRoseControl(htmlColor10, htmlColor20, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ACTOR), uFont4, list, true, iSkinParam, d);
        }
        if (componentType == ComponentType.CONTROL_TAIL) {
            HtmlColor htmlColor21 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBorder);
            return new ComponentRoseControl(htmlColor10, htmlColor21, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ACTOR), uFont4, list, false, iSkinParam, d);
        }
        if (componentType == ComponentType.ENTITY_HEAD) {
            HtmlColor htmlColor22 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBorder);
            return new ComponentRoseEntity(htmlColor10, htmlColor22, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ACTOR), uFont4, list, true, iSkinParam, d);
        }
        if (componentType == ComponentType.ENTITY_TAIL) {
            HtmlColor htmlColor23 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBorder);
            return new ComponentRoseEntity(htmlColor10, htmlColor23, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ACTOR), uFont4, list, false, iSkinParam, d);
        }
        if (componentType == ComponentType.NOTE) {
            HtmlColor htmlColor24 = this.getHtmlColor(iSkinParam, ColorParam.noteBackground);
            HtmlColor htmlColor25 = this.getHtmlColor(iSkinParam, ColorParam.noteBorder);
            UFont uFont5 = iSkinParam.getFont(FontParam.NOTE, null);
            return new ComponentRoseNote(htmlColor24, htmlColor25, this.getFontColor(iSkinParam, FontParam.NOTE), uFont5, list, this.paddingX, this.paddingY, iSkinParam, d);
        }
        if (componentType == ComponentType.NOTE_HEXAGONAL) {
            HtmlColor htmlColor26 = this.getHtmlColor(iSkinParam, ColorParam.noteBackground);
            HtmlColor htmlColor27 = this.getHtmlColor(iSkinParam, ColorParam.noteBorder);
            UFont uFont6 = iSkinParam.getFont(FontParam.NOTE, null);
            return new ComponentRoseNoteHexagonal(htmlColor26, htmlColor27, this.getFontColor(iSkinParam, FontParam.NOTE), uFont6, list, iSkinParam, d);
        }
        if (componentType == ComponentType.NOTE_BOX) {
            HtmlColor htmlColor28 = this.getHtmlColor(iSkinParam, ColorParam.noteBackground);
            HtmlColor htmlColor29 = this.getHtmlColor(iSkinParam, ColorParam.noteBorder);
            UFont uFont7 = iSkinParam.getFont(FontParam.NOTE, null);
            return new ComponentRoseNoteBox(htmlColor28, htmlColor29, this.getFontColor(iSkinParam, FontParam.NOTE), uFont7, list, iSkinParam, d);
        }
        if (componentType == ComponentType.GROUPING_HEADER) {
            UFont uFont8 = iSkinParam.getFont(FontParam.SEQUENCE_GROUP_HEADER, null);
            return new ComponentRoseGroupingHeader(this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP_HEADER), htmlColor, htmlColor3, htmlColor2, uFont8, uFont2, list, iSkinParam, d);
        }
        if (componentType == ComponentType.GROUPING_ELSE) {
            return new ComponentRoseGroupingElse(this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP), htmlColor2, uFont2, list.get(0), iSkinParam, htmlColor);
        }
        if (componentType == ComponentType.GROUPING_SPACE) {
            return new ComponentRoseGroupingSpace(7.0);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            HtmlColor htmlColor30 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor30, htmlColor8, true, true, d > 0.0);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            HtmlColor htmlColor31 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor31, htmlColor8, true, false, d > 0.0);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            HtmlColor htmlColor32 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor32, htmlColor8, false, true, d > 0.0);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            HtmlColor htmlColor33 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor33, htmlColor8, false, false, d > 0.0);
        }
        if (componentType == ComponentType.DELAY_LINE) {
            HtmlColor htmlColor34 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseDelayLine(htmlColor34);
        }
        if (componentType == ComponentType.DELAY_TEXT) {
            return new ComponentRoseDelayText(this.getFontColor(iSkinParam, FontParam.SEQUENCE_DELAY), iSkinParam.getFont(FontParam.SEQUENCE_DELAY, null), list, iSkinParam);
        }
        if (componentType == ComponentType.DESTROY) {
            HtmlColor htmlColor35 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseDestroy(htmlColor35);
        }
        if (componentType == ComponentType.NEWPAGE) {
            return new ComponentRoseNewpage(this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP));
        }
        if (componentType == ComponentType.DIVIDER) {
            return new ComponentRoseDivider(this.getFontColor(iSkinParam, FontParam.SEQUENCE_DIVIDER), iSkinParam.getFont(FontParam.SEQUENCE_DIVIDER, null), htmlColor4, list, iSkinParam, d > 0.0);
        }
        if (componentType == ComponentType.REFERENCE) {
            UFont uFont9 = iSkinParam.getFont(FontParam.SEQUENCE_GROUP_HEADER, null);
            return new ComponentRoseReference(this.getFontColor(iSkinParam, FontParam.SEQUENCE_REFERENCE), this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP), iSkinParam.getFont(FontParam.SEQUENCE_REFERENCE, null), htmlColor7, htmlColor6, htmlColor5, uFont9, list, iSkinParam.getHorizontalAlignement(AlignParam.SEQUENCE_REFERENCE_ALIGN), iSkinParam, d);
        }
        if (componentType == ComponentType.TITLE) {
            return new ComponentRoseTitle(this.getFontColor(iSkinParam, FontParam.SEQUENCE_TITLE), iSkinParam.getFont(FontParam.SEQUENCE_TITLE, null), list, iSkinParam);
        }
        if (componentType == ComponentType.SIGNATURE) {
            return new ComponentRoseTitle(HtmlColorUtils.BLACK, uFont2, Arrays.asList("This skin was created ", "in April 2009."), iSkinParam);
        }
        if (componentType == ComponentType.ENGLOBER) {
            HtmlColor htmlColor36 = this.getHtmlColor(iSkinParam, ColorParam.sequenceBoxBorder);
            HtmlColor htmlColor37 = this.getHtmlColor(iSkinParam, ColorParam.sequenceBoxBackground);
            return new ComponentRoseEnglober(htmlColor36, htmlColor37, list, this.getFontColor(iSkinParam, FontParam.SEQUENCE_BOX), iSkinParam.getFont(FontParam.SEQUENCE_BOX, null), iSkinParam);
        }
        return null;
    }

    @Override
    public Object getProtocolVersion() {
        return 1;
    }
}

