/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.statediagram.StateDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateState2
extends SingleLineCommand2<StateDiagram> {
    public CommandCreateState2(StateDiagram stateDiagram) {
        super(stateDiagram, CommandCreateState2.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("(?:state\\s+)"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("\\s+as\\s+"), new RegexLeaf("DISPLAY", "\"([^\"]+)\""), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("\\s*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        Object object;
        String string;
        Code code = Code.of(regexResult.get("CODE", 0));
        String string2 = regexResult.get("DISPLAY", 0);
        IEntity iEntity = ((StateDiagram)this.getSystem()).getOrCreateLeaf1(code, null);
        iEntity.setDisplay(StringUtils.getWithNewlines(string2));
        String string3 = regexResult.get("STEREOTYPE", 0);
        if (string3 != null) {
            iEntity.setStereotype(new Stereotype(string3));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            object = new UrlBuilder(((StateDiagram)this.getSystem()).getSkinParam().getValue("topurl"), true);
            Url url = ((UrlBuilder)object).getUrl(string);
            iEntity.addUrl(url);
        }
        if ((object = regexResult.get("STEREOTYPE", 0)) != null) {
            iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid((String)object));
        }
        return CommandExecutionResult.ok();
    }
}

