/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import java.util.StringTokenizer;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.statediagram.StateDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkState
extends SingleLineCommand2<StateDiagram> {
    public CommandLinkState(StateDiagram stateDiagram) {
        super(stateDiagram, CommandLinkState.getRegex());
    }

    static RegexConcat getRegex() {
        return new RegexConcat(new RegexLeaf("^"), CommandLinkState.getStatePattern("ENT1"), new RegexLeaf("\\s*"), new RegexConcat(new RegexLeaf("ARROW_CROSS_START", "(x)?"), new RegexLeaf("ARROW_BODY1", "(-+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden)(?:,#\\w+|,dotted|,dashed|,bold|,hidden)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden)(?:,#\\w+|,dotted|,dashed|,bold|,hidden)*)\\])?"), new RegexLeaf("ARROW_BODY2", "(-*)"), new RegexLeaf("\\>"), new RegexLeaf("ARROW_CIRCLE_END", "(o\\s+)?")), new RegexLeaf("\\s*"), CommandLinkState.getStatePattern("ENT2"), new RegexLeaf("\\s*"), new RegexLeaf("LABEL", "(?::\\s*([^\"]+))?"), new RegexLeaf("$"));
    }

    private static RegexLeaf getStatePattern(String string) {
        return new RegexLeaf(string, "([\\p{L}0-9_.]+|[\\p{L}0-9_.]+\\[H\\]|\\[\\*\\]|\\[H\\]|(?:==+)(?:[\\p{L}0-9_.]+)(?:==+))\\s*(\\<\\<.*\\>\\>)?\\s*(#\\w+)?");
    }

    @Override
    protected CommandExecutionResult executeArg(RegexResult regexResult) {
        String string = regexResult.get("ENT1", 0);
        String string2 = regexResult.get("ENT2", 0);
        IEntity iEntity = this.getEntityStart(string);
        IEntity iEntity2 = this.getEntityEnd(string2);
        if (regexResult.get("ENT1", 1) != null) {
            iEntity.setStereotype(new Stereotype(regexResult.get("ENT1", 1)));
        }
        if (regexResult.get("ENT1", 2) != null) {
            iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("ENT1", 2)));
        }
        if (regexResult.get("ENT2", 1) != null) {
            iEntity2.setStereotype(new Stereotype(regexResult.get("ENT2", 1)));
        }
        if (regexResult.get("ENT2", 2) != null) {
            iEntity2.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("ENT2", 2)));
        }
        String string3 = regexResult.get("ARROW_BODY1", 0) + regexResult.get("ARROW_BODY2", 0);
        Direction direction = this.getDirection(regexResult);
        if (direction == Direction.LEFT || direction == Direction.RIGHT) {
            string3 = "-";
        }
        int n = string3.length();
        boolean bl = regexResult.get("ARROW_CROSS_START", 0) != null;
        boolean bl2 = regexResult.get("ARROW_CIRCLE_END", 0) != null;
        LinkType linkType = new LinkType(bl2 ? LinkDecor.ARROW_AND_CIRCLE : LinkDecor.ARROW, bl ? LinkDecor.CIRCLE_CROSS : LinkDecor.NONE);
        Link link = new Link(iEntity, iEntity2, linkType, regexResult.get("LABEL", 0), n);
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        this.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), link);
        ((StateDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }

    private void applyStyle(String string, Link link) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("dashed")) {
                link.goDashed();
                continue;
            }
            if (string2.equalsIgnoreCase("bold")) {
                link.goBold();
                continue;
            }
            if (string2.equalsIgnoreCase("dotted")) {
                link.goDotted();
                continue;
            }
            if (string2.equalsIgnoreCase("hidden")) {
                link.goHidden();
                continue;
            }
            link.setSpecificColor(string2);
        }
    }

    private Direction getDirection(RegexResult regexResult) {
        String string = regexResult.get("ARROW_DIRECTION", 0);
        if (string != null) {
            return StringUtils.getQueueDirection(string);
        }
        return null;
    }

    private IEntity getEntityStart(String string) {
        if (string.startsWith("[*]")) {
            return ((StateDiagram)this.getSystem()).getStart();
        }
        if (string.equalsIgnoreCase("[H]")) {
            return ((StateDiagram)this.getSystem()).getHistorical();
        }
        if (string.endsWith("[H]")) {
            return ((StateDiagram)this.getSystem()).getHistorical(Code.of(string.substring(0, string.length() - 3)));
        }
        if (string.startsWith("=") && string.endsWith("=")) {
            string = this.removeEquals(string);
            return ((StateDiagram)this.getSystem()).getOrCreateLeaf1(Code.of(string), LeafType.SYNCHRO_BAR);
        }
        return ((StateDiagram)this.getSystem()).getOrCreateLeaf1(Code.of(string), null);
    }

    private String removeEquals(String string) {
        while (string.startsWith("=")) {
            string = string.substring(1);
        }
        while (string.endsWith("=")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private IEntity getEntityEnd(String string) {
        if (string.startsWith("[*]")) {
            return ((StateDiagram)this.getSystem()).getEnd();
        }
        if (string.endsWith("[H]")) {
            return ((StateDiagram)this.getSystem()).getHistorical(Code.of(string.substring(0, string.length() - 3)));
        }
        if (string.startsWith("=") && string.endsWith("=")) {
            string = this.removeEquals(string);
            return ((StateDiagram)this.getSystem()).getOrCreateLeaf1(Code.of(string), LeafType.SYNCHRO_BAR);
        }
        return ((StateDiagram)this.getSystem()).getOrCreateLeaf1(Code.of(string), null);
    }
}

