/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.FrontierCalculator;
import net.sourceforge.plantuml.svek.IShapePseudo;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.RoundedContainer;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapePseudoImpl;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster
implements Moveable {
    private final Cluster parent;
    private final IGroup group;
    private final List<Shape> shapes = new ArrayList<Shape>();
    private final List<Cluster> children = new ArrayList<Cluster>();
    private final int color;
    private final int colorTitle;
    private final ISkinParam skinParam;
    private int titleAndAttributeWidth;
    private int titleAndAttributeHeight;
    private TextBlock ztitle;
    private TextBlock zstereo;
    private double xTitle;
    private double yTitle;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    public static final String CENTER_ID = "za";

    @Override
    public void moveSvek(double d, double d2) {
        this.xTitle += d;
        this.minX += d;
        this.maxX += d;
        this.yTitle += d2;
        this.minY += d2;
        this.maxY += d2;
    }

    private boolean hasEntryOrExitPoint() {
        for (Shape shape : this.shapes) {
            if (shape.getEntityPosition() == EntityPosition.NORMAL) continue;
            return true;
        }
        return false;
    }

    public Cluster(ColorSequence colorSequence, ISkinParam iSkinParam, IGroup iGroup) {
        this(null, iGroup, colorSequence, iSkinParam);
    }

    private Cluster(Cluster cluster, IGroup iGroup, ColorSequence colorSequence, ISkinParam iSkinParam) {
        if (iGroup == null) {
            throw new IllegalStateException();
        }
        this.parent = cluster;
        this.group = iGroup;
        this.color = colorSequence.getValue();
        this.colorTitle = colorSequence.getValue();
        this.skinParam = iSkinParam;
    }

    public String toString() {
        return super.toString() + " " + this.group;
    }

    public final Cluster getParent() {
        return this.parent;
    }

    public void addShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shapes.add(shape);
        shape.setCluster(this);
    }

    public final List<Shape> getShapes() {
        return Collections.unmodifiableList(this.shapes);
    }

    private List<Shape> getShapesOrderedTop(Collection<Line> collection) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Shape> hashMap = new HashMap<String, Shape>();
        for (Shape hideable : this.shapes) {
            hashMap.put(hideable.getUid(), hideable);
            if (!hideable.isTop() || hideable.getEntityPosition() != EntityPosition.NORMAL) continue;
            arrayList.add(hideable);
            hashSet.add(hideable.getUid());
        }
        for (Line line : collection) {
            Shape shape;
            if (hashSet.contains(line.getStartUid()) && (shape = (Shape)hashMap.get(line.getEndUid())) != null && shape.getEntityPosition() == EntityPosition.NORMAL) {
                arrayList.add(0, shape);
            }
            if (!line.isInverted() || (shape = (Shape)hashMap.get(line.getStartUid())) == null || shape.getEntityPosition() != EntityPosition.NORMAL) continue;
            arrayList.add(0, shape);
        }
        return arrayList;
    }

    private List<Shape> getShapesEntryExit(EntityPosition entityPosition) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (Shape shape : this.shapes) {
            if (shape.getEntityPosition() != entityPosition) continue;
            arrayList.add(shape);
        }
        return arrayList;
    }

    private List<Shape> getShapesOrderedWithoutTop(Collection<Line> collection) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>(this.shapes);
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Shape> hashMap = new HashMap<String, Shape>();
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Shape hideable = (Shape)iterator.next();
            if (hideable.getEntityPosition() != EntityPosition.NORMAL) {
                iterator.remove();
                continue;
            }
            hashMap.put(hideable.getUid(), hideable);
            if (!hideable.isTop()) continue;
            hashSet.add(hideable.getUid());
            iterator.remove();
        }
        for (Line line : collection) {
            Shape shape;
            if (hashSet.contains(line.getStartUid()) && (shape = (Shape)hashMap.get(line.getEndUid())) != null) {
                arrayList.remove(shape);
            }
            if (!line.isInverted() || (shape = (Shape)hashMap.get(line.getStartUid())) == null) continue;
            arrayList.remove(shape);
        }
        return arrayList;
    }

    public final List<Cluster> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Cluster createChild(IGroup iGroup, int n, int n2, TextBlock textBlock, TextBlock textBlock2, ColorSequence colorSequence, ISkinParam iSkinParam) {
        Cluster cluster = new Cluster(this, iGroup, colorSequence, iSkinParam);
        cluster.titleAndAttributeWidth = n;
        cluster.titleAndAttributeHeight = n2;
        cluster.ztitle = textBlock;
        cluster.zstereo = textBlock2;
        this.children.add(cluster);
        return cluster;
    }

    public final IGroup getGroup() {
        return this.group;
    }

    public final int getTitleAndAttributeWidth() {
        return this.titleAndAttributeWidth;
    }

    public final int getTitleAndAttributeHeight() {
        return this.titleAndAttributeHeight;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getMinX() {
        return this.minX;
    }

    public ClusterPosition getClusterPosition() {
        return new ClusterPosition(this.minX, this.minY, this.maxX, this.maxY);
    }

    public void setTitlePosition(double d, double d2) {
        this.xTitle = d;
        this.yTitle = d2;
    }

    public void drawU(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, DotData dotData) {
        boolean bl;
        if (this.hasEntryOrExitPoint()) {
            this.manageEntryExitPoint(dotData, uGraphic.getStringBounder());
        }
        if (this.skinParam.useSwimlanes()) {
            this.drawSwinLinesState(uGraphic, d, d2, htmlColor, dotData);
            return;
        }
        boolean bl2 = bl = dotData.getUmlDiagramType() == UmlDiagramType.STATE;
        if (bl) {
            this.drawUState(uGraphic, d, d2, htmlColor, dotData);
            return;
        }
        PackageStyle packageStyle = this.group.zgetPackageStyle();
        if (packageStyle == null) {
            packageStyle = dotData.getSkinParam().getPackageStyle();
        }
        if (this.ztitle != null || this.zstereo != null) {
            HtmlColor htmlColor2 = Cluster.getStateBackColor(this.getBackColor(), dotData.getSkinParam(), this.group.getStereotype() == null ? null : this.group.getStereotype().getLabel());
            ClusterDecoration clusterDecoration = new ClusterDecoration(packageStyle, this.group.getUSymbol(), this.ztitle, this.zstereo, htmlColor2, this.minX, this.minY, this.maxX, this.maxY);
            clusterDecoration.drawU(uGraphic, d, d2, htmlColor, dotData.getSkinParam().shadowing());
            return;
        }
        URectangle uRectangle = new URectangle(this.maxX - this.minX, this.maxY - this.minY);
        if (dotData.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(3.0);
        }
        HtmlColor htmlColor3 = Cluster.getStateBackColor(this.getBackColor(), dotData.getSkinParam(), this.group.getStereotype() == null ? null : this.group.getStereotype().getLabel());
        uGraphic.getParam().setBackcolor(htmlColor3);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(d + this.minX, d2 + this.minY, uRectangle);
        uGraphic.getParam().setStroke(new UStroke());
    }

    private void manageEntryExitPoint(DotData dotData, StringBounder stringBounder) {
        ArrayList<ClusterPosition> arrayList = new ArrayList<ClusterPosition>();
        ArrayList<Point2D> arrayList2 = new ArrayList<Point2D>();
        for (Shape object2 : this.shapes) {
            if (object2.getEntityPosition() == EntityPosition.NORMAL) {
                arrayList.add(object2.getClusterPosition());
                continue;
            }
            arrayList2.add(object2.getClusterPosition().getPointCenter());
        }
        for (Cluster cluster : this.children) {
            arrayList.add(cluster.getClusterPosition());
        }
        FrontierCalculator frontierCalculator = new FrontierCalculator(this.getClusterPosition(), arrayList, arrayList2);
        if (this.titleAndAttributeHeight > 0 && this.titleAndAttributeWidth > 0) {
            frontierCalculator.ensureMinWidth(this.titleAndAttributeWidth + 10);
        }
        ClusterPosition clusterPosition = frontierCalculator.getSuggestedPosition();
        this.xTitle += (clusterPosition.getMinX() - this.minX + (clusterPosition.getMaxX() - this.maxX)) / 2.0;
        this.minX = clusterPosition.getMinX();
        this.minY = clusterPosition.getMinY();
        this.maxX = clusterPosition.getMaxX();
        this.maxY = clusterPosition.getMaxY();
        this.yTitle = this.minY + 5.0;
        double d = this.ztitle.calculateDimension(stringBounder).getWidth();
        this.xTitle = this.minX + (this.maxX - this.minX - d) / 2.0;
    }

    private void drawSwinLinesState(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, DotData dotData) {
        if (this.ztitle != null) {
            this.ztitle.drawU(uGraphic, d + this.xTitle, d2);
        }
        ULine uLine = new ULine(0.0, this.maxY - this.minY);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.draw(d + this.minX, d2, uLine);
        uGraphic.draw(d + this.maxX, d2, uLine);
    }

    private HtmlColor getColor(DotData dotData, ColorParam colorParam, String string) {
        return new Rose().getHtmlColor(dotData.getSkinParam(), colorParam, string);
    }

    private void drawUState(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, DotData dotData) {
        Stereotype stereotype;
        boolean bl;
        double d3;
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(this.maxX - this.minX, this.maxY - this.minY);
        double d4 = this.ztitle == null ? 0.0 : this.ztitle.calculateDimension(uGraphic.getStringBounder()).getHeight() + 5.0 + 5.0;
        HtmlColor htmlColor2 = this.getBackColor();
        if (htmlColor2 == null) {
            htmlColor2 = this.getColor(dotData, ColorParam.stateBackground, this.group.getStereotype() == null ? null : this.group.getStereotype().getLabel());
        }
        HtmlColor htmlColor3 = this.getColor(dotData, ColorParam.background, null);
        TextBlockWidth textBlockWidth = this.getTextBlockAttribute(dotData);
        RoundedContainer roundedContainer = new RoundedContainer(dimension2DDouble, d4, d3 + (double)((d3 = textBlockWidth.calculateDimension(uGraphic.getStringBounder()).getHeight()) > 0.0 ? 5 : 0), htmlColor, htmlColor2, htmlColor3);
        roundedContainer.drawU(uGraphic, d + this.minX, d2 + this.minY, dotData.getSkinParam().shadowing());
        if (this.ztitle != null) {
            this.ztitle.drawU(uGraphic, d + this.xTitle, d2 + this.yTitle);
        }
        if (d3 > 0.0) {
            textBlockWidth.drawU(uGraphic, d + this.minX + 5.0, d2 + this.minY + d4 + 2.5, ((Dimension2D)dimension2DDouble).getWidth());
        }
        boolean bl2 = bl = (stereotype = this.group.getStereotype()) != null && stereotype.isWithOOSymbol();
        if (bl) {
            uGraphic.getParam().setColor(htmlColor);
            EntityImageState.drawSymbol(uGraphic, d + this.maxX, d2 + this.maxY);
        }
    }

    private TextBlockWidth getTextBlockAttribute(DotData dotData) {
        List<Member> list = this.group.getFieldsToDisplay();
        TextBlockWidth textBlockWidth = list.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(list, FontParam.STATE_ATTRIBUTE, dotData.getSkinParam());
        return textBlockWidth;
    }

    public void setPosition(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.maxX = d3;
        this.minY = d2;
        this.maxY = d4;
    }

    private boolean isThereALinkFromOrToGroup(Collection<Line> collection) {
        for (Line line : collection) {
            if (!line.isLinkFromOrToGroup(this.group)) continue;
            return true;
        }
        return false;
    }

    public void printCluster1(StringBuilder stringBuilder, Collection<Line> collection) {
        for (Shape shape : this.getShapesOrderedTop(collection)) {
            shape.appendShape(stringBuilder);
        }
    }

    private List<IShapePseudo> addProtection(List<Shape> list, double d) {
        ArrayList<IShapePseudo> arrayList = new ArrayList<IShapePseudo>();
        arrayList.add(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            arrayList.add(new ShapePseudoImpl("psd" + UniqueSequence.getValue(), d, 5.0));
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    private double getMaxWidthFromLabelForEntryExit(List<Shape> list, StringBounder stringBounder) {
        double d = -1.7976931348623157E308;
        for (Shape shape : list) {
            double d2 = this.getMaxWidthFromLabelForEntryExit(shape, stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private double getMaxWidthFromLabelForEntryExit(Shape shape, StringBounder stringBounder) {
        return shape.getMaxWidthFromLabelForEntryExit(stringBounder);
    }

    public void printClusterEntryExit(StringBuilder stringBuilder, StringBounder stringBounder) {
        Iterator<IShapePseudo> iterator;
        List<Shape> list = this.getShapesEntryExit(EntityPosition.ENTRY_POINT);
        double d = this.getMaxWidthFromLabelForEntryExit(list, stringBounder);
        List<IShapePseudo> list2 = d > 70.0 ? this.addProtection(list, d - 70.0) : list;
        if (list2.size() > 0) {
            stringBuilder.append("{rank=source;");
            for (IShapePseudo iterator22 : list2) {
                stringBuilder.append(iterator22.getUid() + ";");
            }
            stringBuilder.append("}");
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                IShapePseudo iShapePseudo = iterator.next();
                iShapePseudo.appendShape(stringBuilder);
            }
        }
        if ((iterator = this.getShapesEntryExit(EntityPosition.EXIT_POINT)).size() > 0) {
            Shape shape;
            stringBuilder.append("{rank=sink;");
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                shape = (Shape)iterator2.next();
                stringBuilder.append(shape.getUid() + ";");
            }
            stringBuilder.append("}");
            Iterator iterator3 = iterator.iterator();
            while (iterator3.hasNext()) {
                shape = (Shape)iterator3.next();
                shape.appendShape(stringBuilder);
            }
        }
    }

    public boolean printCluster2(StringBuilder stringBuilder, Collection<Line> collection, StringBounder stringBounder) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Line object : collection) {
            String string;
            if (object.hasEntryPoint()) continue;
            String string2 = object.getStartUid();
            String string3 = object.getEndUid();
            if (!this.isInCluster(string2) || !this.isInCluster(string3) || (string = object.rankSame()) == null) continue;
            hashSet.add(string);
        }
        boolean bl = false;
        for (Shape shape : this.getShapesOrderedWithoutTop(collection)) {
            shape.appendShape(stringBuilder);
            bl = true;
        }
        for (String string : hashSet) {
            stringBuilder.append(string);
            SvekUtils.println(stringBuilder);
        }
        for (Cluster cluster : this.getChildren()) {
            cluster.printInternal(stringBuilder, collection, stringBounder);
        }
        return bl;
    }

    public void fillRankMin(Set<String> set) {
        for (Shape moveable : this.getShapes()) {
            if (!moveable.isTop()) continue;
            set.add(moveable.getUid());
        }
        for (Cluster cluster : this.getChildren()) {
            cluster.fillRankMin(set);
        }
    }

    private boolean isInCluster(String string) {
        for (Shape shape : this.shapes) {
            if (!shape.getUid().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getClusterId() {
        return "cluster" + this.color;
    }

    public static String getSpecialPointId(IEntity iEntity) {
        return CENTER_ID + iEntity.getUid();
    }

    private boolean protection0() {
        return !this.skinParam.useSwimlanes();
    }

    private boolean protection1() {
        return !this.skinParam.useSwimlanes();
    }

    public String getMinPoint() {
        if (this.skinParam.useSwimlanes()) {
            return "minPoint" + this.color;
        }
        return null;
    }

    public String getMaxPoint() {
        if (this.skinParam.useSwimlanes()) {
            return "maxPoint" + this.color;
        }
        return null;
    }

    private String getSourceInPoint() {
        if (this.skinParam.useSwimlanes()) {
            return "sourceIn" + this.color;
        }
        return null;
    }

    private String getSinkInPoint() {
        if (this.skinParam.useSwimlanes()) {
            return "sinkIn" + this.color;
        }
        return null;
    }

    private void printInternal(StringBuilder stringBuilder, Collection<Line> collection, StringBounder stringBounder) {
        String string;
        boolean bl;
        boolean bl2;
        boolean bl3 = this.isThereALinkFromOrToGroup(collection);
        if (bl3) {
            this.subgraphCluster(stringBuilder, "a");
        }
        if (bl2 = this.hasEntryOrExitPoint()) {
            for (Line line : collection) {
                if (!line.isLinkFromOrToGroup(this.group)) continue;
                line.setProjectionCluster(this);
            }
        }
        boolean bl4 = this.protection0();
        boolean bl5 = this.protection1();
        if (bl2) {
            bl4 = false;
            bl5 = false;
        }
        if (bl4) {
            this.subgraphCluster(stringBuilder, "p0");
        }
        stringBuilder.append("subgraph " + this.getClusterId() + " {");
        stringBuilder.append("style=solid;");
        stringBuilder.append("color=\"" + StringUtils.getAsHtml(this.color) + "\";");
        boolean bl6 = bl = this.getTitleAndAttributeHeight() > 0 && this.getTitleAndAttributeWidth() > 0;
        if (bl) {
            StringBuilder stringBuilder2 = new StringBuilder("<");
            Line.appendTable(stringBuilder2, this.getTitleAndAttributeWidth(), this.getTitleAndAttributeHeight() - 5, this.colorTitle);
            stringBuilder2.append(">");
            string = stringBuilder2.toString();
        } else {
            string = "\"\"";
        }
        if (bl2) {
            this.printClusterEntryExit(stringBuilder, stringBounder);
            this.subgraphCluster(stringBuilder, "ee", string);
        } else {
            stringBuilder.append("label=" + string + ";");
            SvekUtils.println(stringBuilder);
        }
        if (bl3) {
            stringBuilder.append(Cluster.getSpecialPointId(this.group) + " [shape=point,width=.01,label=\"\"];");
            this.subgraphCluster(stringBuilder, "i");
        }
        if (bl5) {
            this.subgraphCluster(stringBuilder, "p1");
        }
        if (this.skinParam.useSwimlanes()) {
            stringBuilder.append("{rank = source; ");
            stringBuilder.append(this.getSourceInPoint());
            stringBuilder.append(" [shape=point,width=.01,label=\"\"];");
            stringBuilder.append(this.getMinPoint() + "->" + this.getSourceInPoint() + "  [weight=999];");
            stringBuilder.append("}");
            SvekUtils.println(stringBuilder);
            stringBuilder.append("{rank = sink; ");
            stringBuilder.append(this.getSinkInPoint());
            stringBuilder.append(" [shape=point,width=.01,label=\"\"];");
            stringBuilder.append("}");
            stringBuilder.append(this.getSinkInPoint() + "->" + this.getMaxPoint() + "  [weight=999];");
            SvekUtils.println(stringBuilder);
        }
        SvekUtils.println(stringBuilder);
        this.printCluster1(stringBuilder, collection);
        boolean bl7 = this.printCluster2(stringBuilder, collection, stringBounder);
        if (bl2 && !bl7) {
            String string2 = "empty" + this.color;
            stringBuilder.append(string2 + " [shape=point,width=.01,label=\"\"];");
        }
        stringBuilder.append("}");
        if (bl5) {
            stringBuilder.append("}");
        }
        if (bl3) {
            stringBuilder.append("}");
            stringBuilder.append("}");
        }
        if (bl2) {
            stringBuilder.append("}");
        }
        if (bl4) {
            stringBuilder.append("}");
        }
        SvekUtils.println(stringBuilder);
    }

    private void subgraphCluster(StringBuilder stringBuilder, String string) {
        this.subgraphCluster(stringBuilder, string, "\"\"");
    }

    private void subgraphCluster(StringBuilder stringBuilder, String string, String string2) {
        String string3 = this.getClusterId() + string;
        stringBuilder.append("subgraph " + string3 + " {");
        stringBuilder.append("label=" + string2 + ";");
    }

    public int getColor() {
        return this.color;
    }

    public int getTitleColor() {
        return this.colorTitle;
    }

    private final HtmlColor getBackColor() {
        if (EntityUtils.groupRoot(this.group)) {
            return null;
        }
        HtmlColor htmlColor = this.group.getSpecificBackColor();
        if (htmlColor != null) {
            return htmlColor;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getBackColor();
    }

    public boolean isClusterOf(IEntity iEntity) {
        if (!iEntity.isGroup()) {
            return false;
        }
        return this.group == iEntity;
    }

    public static HtmlColor getStateBackColor(HtmlColor htmlColor, ISkinParam iSkinParam, String string) {
        if (htmlColor == null) {
            htmlColor = iSkinParam.getHtmlColor(ColorParam.packageBackground, string, false);
        }
        if (htmlColor == null) {
            htmlColor = iSkinParam.getHtmlColor(ColorParam.background, string, false);
        }
        if (htmlColor == null) {
            htmlColor = HtmlColorUtils.WHITE;
        }
        return htmlColor;
    }
}

