/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramFileMakerResult;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierActivity;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramSimplifierState;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.DecorateEntityImage;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramFileMakerSvek {
    private final CucaDiagram diagram;
    private final List<BufferedImage> flashcodes;
    private static final StringBounder stringBounder;
    private String warningOrError;

    public CucaDiagramFileMakerSvek(CucaDiagram cucaDiagram, List<BufferedImage> list) throws IOException {
        this.diagram = cucaDiagram;
        this.flashcodes = list;
    }

    public CucaDiagramFileMakerResult createFile(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException {
        try {
            return this.createFileInternal(outputStream, list, fileFormatOption);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new IOException(interruptedException);
        }
    }

    private CucaDiagramFileMakerResult createFileInternal(OutputStream outputStream, List<String> list, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        String string;
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            new CucaDiagramSimplifierActivity(this.diagram, list);
        } else if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            new CucaDiagramSimplifierState(this.diagram, list);
        }
        DotData dotData = new DotData(this.diagram.getEntityFactory().getRootGroup(), this.diagram.getLinks(), this.diagram.getLeafs().values(), this.diagram.getUmlDiagramType(), this.diagram.getSkinParam(), this.diagram.getRankdir(), this.diagram, this.diagram, this.diagram.getColorMapper(), this.diagram.getEntityFactory());
        CucaDiagramFileMakerSvek2 cucaDiagramFileMakerSvek2 = new CucaDiagramFileMakerSvek2(dotData, this.diagram.getEntityFactory(), false);
        IEntityImage iEntityImage = cucaDiagramFileMakerSvek2.createFile(this.diagram.getDotStringSkek());
        iEntityImage = this.addTitle(iEntityImage);
        iEntityImage = this.addHeaderAndFooter(iEntityImage);
        Dimension2D dimension2D = iEntityImage.getDimension(stringBounder);
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            this.createPng(outputStream, fileFormatOption, iEntityImage, dimension2D);
        } else if (fileFormat == FileFormat.SVG) {
            this.createSvg(outputStream, fileFormatOption, iEntityImage, dimension2D);
        } else if (fileFormat == FileFormat.EPS) {
            this.createEps(outputStream, fileFormatOption, iEntityImage, dimension2D);
        } else {
            throw new UnsupportedOperationException(fileFormat.toString());
        }
        double d = 0.0;
        double d2 = 0.0;
        if (iEntityImage instanceof DecorateEntityImage) {
            d += ((DecorateEntityImage)iEntityImage).getDeltaX();
            d2 += ((DecorateEntityImage)iEntityImage).getDeltaY();
        }
        Dimension2D dimension2D2 = Dimension2DDouble.delta(dimension2D, d, d2);
        CMapData cMapData = null;
        if (this.diagram.hasUrl() && fileFormatOption.getFileFormat() == FileFormat.PNG) {
            cMapData = this.cmapString(cucaDiagramFileMakerSvek2);
        }
        this.warningOrError = (string = this.diagram.getSkinParam().getValue("widthwarning")) != null && string.matches("\\d+") ? cucaDiagramFileMakerSvek2.getBibliotekon().getWarningOrError(Integer.parseInt(string)) : null;
        return new CucaDiagramFileMakerResult(cMapData, dimension2D2.getWidth(), this.getWarningOrError());
    }

    private String getWarningOrError() {
        return this.warningOrError;
    }

    private CMapData cmapString(CucaDiagramFileMakerSvek2 cucaDiagramFileMakerSvek2) {
        Object object;
        CMapData cMapData = new CMapData();
        int n = 1;
        for (ILeaf hideable : this.diagram.getLeafs().values()) {
            object = new ArrayList<Url>(hideable.getUrls());
            Collections.reverse(object);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Url url = (Url)iterator.next();
                this.appendUrl(cMapData, n, url);
                ++n;
            }
        }
        for (Link link : this.diagram.getLinks()) {
            object = link.getUrl();
            if (object == null) continue;
            this.appendUrl(cMapData, n, (Url)object);
            ++n;
        }
        return cMapData;
    }

    private void appendUrl(CMapData cMapData, int n, Url url) {
        cMapData.appendString("<area shape=\"rect\" id=\"id");
        cMapData.appendLong(n);
        cMapData.appendString("\" href=\"");
        cMapData.appendString(url.getUrl());
        cMapData.appendString("\" title=\"");
        cMapData.appendString(url.getTooltip());
        cMapData.appendString("\" alt=\"\" coords=\"");
        cMapData.appendString(url.getCoords());
        cMapData.appendString("\"/>");
        cMapData.appendString("\n");
    }

    private IEntityImage addHeaderAndFooter(IEntityImage iEntityImage) {
        List<String> list = this.diagram.getFooter();
        List<String> list2 = this.diagram.getHeader();
        if (list == null && list2 == null) {
            return iEntityImage;
        }
        TextBlock textBlock = list == null ? null : TextBlockUtils.create(list, new FontConfiguration(this.getFont(FontParam.FOOTER), this.getFontColor(FontParam.FOOTER, null)), this.diagram.getFooterAlignement(), this.diagram.getSkinParam());
        TextBlock textBlock2 = list2 == null ? null : TextBlockUtils.create(list2, new FontConfiguration(this.getFont(FontParam.HEADER), this.getFontColor(FontParam.HEADER, null)), this.diagram.getHeaderAlignement(), this.diagram.getSkinParam());
        return new DecorateEntityImage(iEntityImage, textBlock2, this.diagram.getHeaderAlignement(), textBlock, this.diagram.getFooterAlignement());
    }

    private IEntityImage addTitle(IEntityImage iEntityImage) {
        List<? extends CharSequence> list = this.diagram.getTitle();
        if (list == null) {
            return iEntityImage;
        }
        TextBlock textBlock = TextBlockUtils.create(list, new FontConfiguration(this.getFont(FontParam.TITLE), this.getFontColor(FontParam.TITLE, null)), HorizontalAlignement.CENTER, this.diagram.getSkinParam());
        return new DecorateEntityImage(iEntityImage, textBlock, HorizontalAlignement.CENTER);
    }

    private final UFont getFont(FontParam fontParam) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return iSkinParam.getFont(fontParam, null);
    }

    private final HtmlColor getFontColor(FontParam fontParam, String string) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return iSkinParam.getFontHtmlColor(fontParam, string);
    }

    private void createPng(OutputStream outputStream, FileFormatOption fileFormatOption, IEntityImage iEntityImage, Dimension2D dimension2D) throws IOException {
        Graphics2D graphics2D;
        EmptyImageBuilder emptyImageBuilder;
        Scale scale;
        Color color = Color.WHITE;
        if (iEntityImage.getBackcolor() instanceof HtmlColorSimple) {
            color = this.diagram.getSkinParam().getColorMapper().getMappedColor(iEntityImage.getBackcolor());
        }
        double d = (scale = this.diagram.getScale()) == null ? this.diagram.getDpiFactor(fileFormatOption) : scale.getScale(dimension2D.getWidth(), dimension2D.getHeight());
        if (this.diagram.isRotation()) {
            emptyImageBuilder = new EmptyImageBuilder((int)(dimension2D.getHeight() * d), (int)(dimension2D.getWidth() * d), color);
            graphics2D = emptyImageBuilder.getGraphics2D();
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-emptyImageBuilder.getBufferedImage().getHeight(), 0);
        } else {
            emptyImageBuilder = new EmptyImageBuilder((int)(dimension2D.getWidth() * d), (int)(dimension2D.getHeight() * d), color);
            graphics2D = emptyImageBuilder.getGraphics2D();
        }
        UGraphicG2d uGraphicG2d = new UGraphicG2d(this.diagram.getSkinParam().getColorMapper(), graphics2D, emptyImageBuilder.getBufferedImage(), d);
        BufferedImage bufferedImage = uGraphicG2d.getBufferedImage();
        if (iEntityImage.getBackcolor() instanceof HtmlColorGradient) {
            uGraphicG2d.getParam().setBackcolor(iEntityImage.getBackcolor());
            uGraphicG2d.draw(0.0, 0.0, new URectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
            uGraphicG2d.getParam().setBackcolor(null);
        }
        iEntityImage.drawU(uGraphicG2d, 0.0, 0.0);
        PngIO.write((RenderedImage)bufferedImage, outputStream, this.diagram.getMetadata(), this.diagram.getDpi(fileFormatOption));
    }

    private void createSvg(OutputStream outputStream, FileFormatOption fileFormatOption, IEntityImage iEntityImage, Dimension2D dimension2D) throws IOException {
        Color color = Color.WHITE;
        if (iEntityImage.getBackcolor() instanceof HtmlColorSimple) {
            color = this.diagram.getSkinParam().getColorMapper().getMappedColor(iEntityImage.getBackcolor());
        }
        UGraphicSvg uGraphicSvg = iEntityImage.getBackcolor() instanceof HtmlColorGradient ? new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), (HtmlColorGradient)iEntityImage.getBackcolor(), false) : (color == null || color.equals(Color.WHITE) ? new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), false) : new UGraphicSvg(this.diagram.getSkinParam().getColorMapper(), StringUtils.getAsHtml(color), false));
        iEntityImage.drawU(uGraphicSvg, 0.0, 0.0);
        uGraphicSvg.createXml(outputStream);
    }

    private void createEps(OutputStream outputStream, FileFormatOption fileFormatOption, IEntityImage iEntityImage, Dimension2D dimension2D) throws IOException {
        UGraphicEps uGraphicEps = new UGraphicEps(this.diagram.getSkinParam().getColorMapper(), EpsStrategy.getDefault2());
        iEntityImage.drawU(uGraphicEps, 0.0, 0.0);
        outputStream.write(uGraphicEps.getEPSCode().getBytes());
    }

    static {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, Color.WHITE);
        stringBounder = StringBounderUtils.asStringBounder(emptyImageBuilder.getGraphics2D());
    }
}

