/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.RoundedContainer;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InnerStateAutonom
implements IEntityImage {
    private final IEntityImage im;
    private final TextBlock title;
    private final TextBlockWidth attribute;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final boolean shadowing;
    private final List<Url> url;
    private final List<Url> suburl;
    private final boolean withSymbol;
    public static final double THICKNESS_BORDER = 1.5;

    public InnerStateAutonom(IEntityImage iEntityImage, TextBlock textBlock, TextBlockWidth textBlockWidth, HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl, List<Url> list, List<Url> list2, boolean bl2) {
        this.im = iEntityImage;
        this.withSymbol = bl2;
        this.title = textBlock;
        this.borderColor = htmlColor;
        this.backColor = htmlColor2;
        this.shadowing = bl;
        this.attribute = textBlockWidth;
        this.url = list2;
        this.suburl = list;
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        Dimension2D dimension2D2 = this.attribute.calculateDimension(uGraphic.getStringBounder());
        Dimension2D dimension2D3 = this.getDimension(uGraphic.getStringBounder());
        double d3 = dimension2D2.getHeight() > 0.0 ? 5.0 : 0.0;
        double d4 = 5.0 + dimension2D.getHeight() + 5.0;
        RoundedContainer roundedContainer = new RoundedContainer(dimension2D3, d4, dimension2D2.getHeight() + d3, this.borderColor, this.backColor, this.im.getBackcolor());
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        roundedContainer.drawU(uGraphic, d, d2, this.shadowing);
        this.title.drawU(uGraphic, d + (dimension2D3.getWidth() - dimension2D.getWidth()) / 2.0, d2 + 5.0);
        this.attribute.drawU(uGraphic, d + 5.0, d2 + 5.0 + dimension2D.getHeight() + 5.0, dimension2D3.getWidth());
        double d5 = this.getSpaceYforURL(uGraphic.getStringBounder());
        this.im.drawU(uGraphic, d + 5.0, d2 + d5);
        if (this.withSymbol) {
            uGraphic.getParam().setColor(this.borderColor);
            EntityImageState.drawSymbol(uGraphic, d + dimension2D3.getWidth(), d2 + dimension2D3.getHeight());
        }
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    private double getSpaceYforURL(StringBounder stringBounder) {
        Dimension2D dimension2D = this.title.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.attribute.calculateDimension(stringBounder);
        double d = dimension2D2.getHeight() > 0.0 ? 5.0 : 0.0;
        double d2 = 5.0 + dimension2D.getHeight() + 5.0;
        double d3 = d2 + d + dimension2D2.getHeight();
        return d3 + 5.0;
    }

    @Override
    public HtmlColor getBackcolor() {
        return null;
    }

    @Override
    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.im.getDimension(stringBounder);
        Dimension2D dimension2D2 = this.title.calculateDimension(stringBounder);
        Dimension2D dimension2D3 = this.attribute.calculateDimension(stringBounder);
        Dimension2D dimension2D4 = Dimension2DDouble.mergeTB(dimension2D2, dimension2D3, dimension2D);
        double d = dimension2D3.getHeight() > 0.0 ? 5.0 : 0.0;
        Dimension2D dimension2D5 = Dimension2DDouble.delta(dimension2D4, 20.0 + d);
        return dimension2D5;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }

    @Override
    public boolean isHidden() {
        return this.im.isHidden();
    }
}

