/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SvekResult
implements IEntityImage,
Moveable {
    private final Rose rose = new Rose();
    private final HtmlColor clusterBorder;
    private ClusterPosition dim;
    private final DotData dotData;
    private final DotStringFactory dotStringFactory;
    private final boolean hasVerticalLine;

    public SvekResult(ClusterPosition clusterPosition, DotData dotData, DotStringFactory dotStringFactory, HtmlColor htmlColor, boolean bl) {
        this.dim = clusterPosition;
        this.dotData = dotData;
        this.dotStringFactory = dotStringFactory;
        this.clusterBorder = htmlColor;
        this.hasVerticalLine = bl;
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        for (Cluster iterator : this.dotStringFactory.getBibliotekon().allCluster()) {
            iterator.drawU(uGraphic, d, d2, this.clusterBorder, this.dotData);
        }
        TreeSet treeSet = new TreeSet();
        for (Shape shape : this.dotStringFactory.getBibliotekon().allShapes()) {
            double d3 = shape.getMinX();
            double d4 = shape.getMinY();
            if (shape.isHidden()) {
                uGraphic.getParam().setHidden(true);
            }
            shape.getImage().drawU(uGraphic, d + d3, d2 + d4);
            uGraphic.getParam().setHidden(false);
            if (!this.hasVerticalLine) continue;
            double d5 = d + d3;
            treeSet.add(d5);
            treeSet.add(d5 + shape.getWidth());
        }
        for (Line line : this.dotStringFactory.getBibliotekon().allLines()) {
            if (line.isHidden()) {
                uGraphic.getParam().setHidden(true);
            }
            HtmlColor htmlColor = this.rose.getHtmlColor(this.dotData.getSkinParam(), this.getArrowColorParam(), null);
            line.drawU(uGraphic, d, d2, htmlColor);
            uGraphic.getParam().setHidden(false);
        }
        if (treeSet.size() > 0) {
            double d6 = this.getDimension(uGraphic.getStringBounder()).getHeight();
            uGraphic.getParam().setColor(this.clusterBorder);
            uGraphic.getParam().setStroke(new UStroke(8.0, 10.0, 1.5));
            for (Double d7 : this.middeling(treeSet)) {
                uGraphic.draw(d7, d2, new ULine(0.0, d6));
            }
            uGraphic.getParam().setStroke(new UStroke());
        }
    }

    private Collection<Double> middeling(Set<Double> set) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Iterator<Double> iterator = set.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            double d = iterator.next();
            if (!iterator.hasNext()) {
                return arrayList;
            }
            double d2 = iterator.next();
            arrayList.add((d + d2) / 2.0);
        }
        return arrayList;
    }

    private ColorParam getArrowColorParam() {
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.CLASS) {
            return ColorParam.classArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.OBJECT) {
            return ColorParam.objectArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.USECASE) {
            return ColorParam.usecaseArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.DESCRIPTION) {
            return ColorParam.usecaseArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return ColorParam.activityArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.COMPONENT) {
            return ColorParam.componentArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.STATE) {
            return ColorParam.stateArrow;
        }
        throw new IllegalStateException();
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.dotData.getSkinParam().getBackgroundColor();
    }

    @Override
    public Dimension2D getDimension(StringBounder stringBounder) {
        return this.dim.getDimension();
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }

    @Override
    public void moveSvek(double d, double d2) {
        this.dotStringFactory.moveSvek(d, d2);
        this.dim = this.dim.delta(d > 0.0 ? d : 0.0, d2 > 0.0 ? d2 : 0.0);
    }

    @Override
    public boolean isHidden() {
        return false;
    }
}

