/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

class ExtremityStateLine2
extends Extremity
implements UDrawable {
    private UPolygon polygon = new UPolygon();
    private final Point2D dest;
    private final double radius = 5.0;
    private final double angle;

    public ExtremityStateLine2(double d, Point2D point2D) {
        this.angle = this.manageround(d);
        this.polygon.addPoint(0.0, 0.0);
        this.dest = new Point2D.Double(point2D.getX(), point2D.getY());
        this.polygon.addPoint(-9.0, -4.0);
        this.polygon.addPoint(-5.0, 0.0);
        this.polygon.addPoint(-9.0, 4.0);
        this.polygon.addPoint(0.0, 0.0);
        this.polygon.rotate(this.angle);
        this.polygon = this.polygon.translate(point2D.getX(), point2D.getY());
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        uGraphic.getParam().setBackcolor(uGraphic.getParam().getColor());
        uGraphic.draw(d - 5.0 * Math.cos(this.angle), d2 - 5.0 * Math.sin(this.angle), this.polygon);
        uGraphic.getParam().setBackcolor(HtmlColorUtils.WHITE);
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.draw(d + this.dest.getX() - 5.0, d2 + this.dest.getY() - 5.0, new UEllipse(10.0, 10.0));
        uGraphic.getParam().setStroke(new UStroke());
        uGraphic.getParam().setBackcolor(null);
    }
}

