/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.EntityImageClassHeader2;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGroup;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageClass
extends AbstractEntityImage {
    private final TextBlockWidth body;
    private final int shield;
    private final EntityImageClassHeader2 header;
    private final List<Url> url;
    private final TextBlockWidth mouseOver;
    private final double roundCorner;

    public EntityImageClass(ILeaf iLeaf, ISkinParam iSkinParam, PortionShower portionShower) {
        super(iLeaf, iSkinParam);
        this.roundCorner = iSkinParam.getRoundCorner();
        this.shield = iLeaf.hasNearDecoration() ? 16 : 0;
        this.body = iLeaf.getBody(portionShower).asTextBlock(FontParam.CLASS_ATTRIBUTE, iSkinParam);
        this.header = new EntityImageClassHeader2(iLeaf, iSkinParam, portionShower);
        this.url = iLeaf.getUrls();
        this.mouseOver = iLeaf.getMouseOver() == null ? null : iLeaf.getMouseOver().asTextBlock(FontParam.CLASS_ATTRIBUTE, iSkinParam);
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.header.getDimension(stringBounder);
        Dimension2D dimension2D2 = this.body == null ? new Dimension2DDouble(0.0, 0.0) : this.body.calculateDimension(stringBounder);
        double d = Math.max(dimension2D2.getWidth(), dimension2D.getWidth());
        double d2 = dimension2D2.getHeight() + dimension2D.getHeight();
        return new Dimension2DDouble(d, d2);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        if (this.url.size() > 0 && !this.url.get(0).isMember()) {
            uGraphic.startUrl(this.url.get(0));
        }
        this.drawInternal(uGraphic, d, d2);
        if (this.mouseOver != null) {
            UGroup uGroup = uGraphic.createGroup();
            uGraphic.getParam().setBackcolor(this.getColor(ColorParam.classBackground, this.getStereo()));
            Dimension2D dimension2D = this.mouseOver.calculateDimension(uGraphic.getStringBounder());
            URectangle uRectangle = new URectangle(dimension2D.getWidth(), dimension2D.getHeight());
            if (this.getSkinParam().shadowing()) {
                uRectangle.setDeltaShadow(4.0);
            }
            HtmlColor htmlColor = this.getColor(ColorParam.classBorder, this.getStereo());
            uGraphic.getParam().setColor(htmlColor);
            uGraphic.getParam().setBackcolor(this.getColor(ColorParam.classBackground, this.getStereo()));
            double d3 = d + 30.0;
            double d4 = d2 + 30.0;
            uGraphic.getParam().setStroke(new UStroke(1.5));
            uGroup.draw(d3, d4, uRectangle);
            uGraphic.getParam().setStroke(new UStroke());
            this.mouseOver.drawU(uGraphic, d3, d4, dimension2D.getWidth());
            uGroup.close();
        }
        if (this.url.size() > 0 && !this.url.get(0).isMember()) {
            uGraphic.closeAction();
        }
    }

    private void drawInternal(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getDimension(stringBounder);
        Dimension2D dimension2D2 = this.header.getDimension(stringBounder);
        double d3 = dimension2D.getWidth();
        double d4 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d3, d4, this.roundCorner, this.roundCorner);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        HtmlColor htmlColor = this.getColor(ColorParam.classBorder, this.getStereo());
        uGraphic.getParam().setColor(htmlColor);
        HtmlColor htmlColor2 = this.getEntity().getSpecificBackColor();
        if (htmlColor2 == null) {
            htmlColor2 = this.getColor(ColorParam.classBackground, this.getStereo());
        }
        uGraphic.getParam().setBackcolor(htmlColor2);
        double d5 = d;
        double d6 = d2;
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.draw(d5, d6, uRectangle);
        uGraphic.getParam().setStroke(new UStroke());
        uGraphic.getParam().setBackcolor(htmlColor2);
        this.header.drawU(uGraphic, d5, d6, dimension2D.getWidth(), dimension2D2.getHeight());
        d6 += dimension2D2.getHeight();
        d5 = d;
        if (this.body != null) {
            uGraphic.getParam().setBackcolor(htmlColor2);
            uGraphic.getParam().setColor(htmlColor);
            this.body.drawU(uGraphic, d5, d6, d3);
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return this.shield;
    }
}

