/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageStateBorder
extends AbstractEntityImage {
    public static final double RADIUS = 6.0;
    private final TextBlock desc;
    private final Cluster stateParent;
    private final EntityPosition entityPosition;

    public EntityImageStateBorder(ILeaf iLeaf, ISkinParam iSkinParam, Cluster cluster) {
        super(iLeaf, iSkinParam);
        this.entityPosition = iLeaf.getEntityPosition();
        if (this.entityPosition == EntityPosition.NORMAL) {
            throw new IllegalArgumentException();
        }
        this.stateParent = cluster;
        Stereotype stereotype = iLeaf.getStereotype();
        this.desc = TextBlockUtils.create(iLeaf.getDisplay(), new FontConfiguration(this.getFont(FontParam.STATE, stereotype), this.getFontColor(FontParam.STATE, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
    }

    private boolean upPosition(double d) {
        Point2D point2D = this.stateParent.getClusterPosition().getPointCenter();
        return d < point2D.getY();
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(12.0, 12.0);
    }

    public double getMaxWidthFromLabelForEntryExit(StringBounder stringBounder) {
        Dimension2D dimension2D = this.desc.calculateDimension(stringBounder);
        return dimension2D.getWidth();
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        UEllipse uEllipse = new UEllipse(12.0, 12.0);
        double d3 = d2;
        Dimension2D dimension2D = this.desc.calculateDimension(uGraphic.getStringBounder());
        double d4 = d - (dimension2D.getWidth() - 12.0) / 2.0;
        d3 = this.upPosition(d2) ? (d3 -= 12.0 + dimension2D.getHeight()) : (d3 += 12.0);
        this.desc.drawU(uGraphic, d4, d3);
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.getParam().setColor(this.getColor(ColorParam.stateBorder, this.getStereo()));
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = this.getColor(ColorParam.stateBackground, this.getStereo());
        }
        uGraphic.getParam().setBackcolor(htmlColor);
        uGraphic.draw(d, d2, uEllipse);
        if (this.entityPosition == EntityPosition.EXIT_POINT) {
            double d5 = d + 6.0 + 0.5;
            double d6 = d2 + 6.0 + 0.5;
            EntityImageStateBorder.drawLine(uGraphic, this.getPointOnCircle(d5, d6, 0.7853981633974483, 5.5), this.getPointOnCircle(d5, d6, 3.9269908169872414, 5.5));
            EntityImageStateBorder.drawLine(uGraphic, this.getPointOnCircle(d5, d6, -0.7853981633974483, 5.5), this.getPointOnCircle(d5, d6, 2.356194490192345, 5.5));
            uGraphic.getParam().setStroke(new UStroke());
        }
    }

    private Point2D getPointOnCircle(double d, double d2, double d3, double d4) {
        double d5 = d + d4 * Math.cos(d3);
        double d6 = d2 + d4 * Math.sin(d3);
        return new Point2D.Double(d5, d6);
    }

    private static void drawLine(UGraphic uGraphic, Point2D point2D, Point2D point2D2) {
        double d = point2D2.getX() - point2D.getX();
        double d2 = point2D2.getY() - point2D.getY();
        uGraphic.draw(point2D.getX(), point2D.getY(), new ULine(d, d2));
    }

    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }

    public int getShield() {
        return 0;
    }
}

