/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGroup;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

public abstract class UGraphicUtils {
    public static UDrawable translate(final UDrawable uDrawable, final double d, final double d2) {
        return new UDrawable(){

            public void drawU(UGraphic uGraphic, double d3, double d22) {
                uDrawable.drawU(uGraphic, d3 + d, d22 + d2);
            }
        };
    }

    public static UGraphic translate(final UGraphic uGraphic, final double d, final double d2) {
        return new UGraphic(){

            public void centerChar(double d3, double d22, char c, UFont uFont) {
                uGraphic.centerChar(d + d3, d2 + d22, c, uFont);
            }

            public void draw(double d3, double d22, UShape uShape) {
                uGraphic.draw(d + d3, d2 + d22, uShape);
            }

            public UParam getParam() {
                return uGraphic.getParam();
            }

            public StringBounder getStringBounder() {
                return uGraphic.getStringBounder();
            }

            public double getTranslateX() {
                return uGraphic.getTranslateX();
            }

            public double getTranslateY() {
                return uGraphic.getTranslateY();
            }

            public void setClip(UClip uClip) {
                throw new UnsupportedOperationException();
            }

            public void setTranslate(double d3, double d22) {
                uGraphic.setTranslate(d3, d22);
            }

            public void translate(double d3, double d22) {
                uGraphic.translate(d3, d22);
            }

            public void setAntiAliasing(boolean bl) {
                uGraphic.setAntiAliasing(bl);
            }

            public void startUrl(Url url) {
                uGraphic.startUrl(url);
            }

            public void closeAction() {
                uGraphic.closeAction();
            }

            public ColorMapper getColorMapper() {
                return uGraphic.getColorMapper();
            }

            public UGroup createGroup() {
                return uGraphic.createGroup();
            }
        };
    }

    public static void writeImage(OutputStream outputStream, String string, FileFormatOption fileFormatOption, ColorMapper colorMapper, HtmlColor htmlColor, TextBlock textBlock) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            BufferedImage bufferedImage = UGraphicUtils.createImage(colorMapper, htmlColor, textBlock);
            PngIO.write((RenderedImage)bufferedImage, outputStream, string, 96);
        } else if (fileFormat == FileFormat.SVG) {
            UGraphicSvg uGraphicSvg = new UGraphicSvg(colorMapper, StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColor)), false);
            textBlock.drawU(uGraphicSvg, 0.0, 0.0);
            uGraphicSvg.createXml(outputStream);
        } else if (fileFormat == FileFormat.EPS) {
            UGraphicEps uGraphicEps = new UGraphicEps(colorMapper, EpsStrategy.getDefault2());
            textBlock.drawU(uGraphicEps, 0.0, 0.0);
            outputStream.write(uGraphicEps.getEPSCode().getBytes());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static BufferedImage createImage(ColorMapper colorMapper, HtmlColor htmlColor, TextBlock textBlock) {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, colorMapper.getMappedColor(htmlColor));
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d = new UGraphicG2d(colorMapper, graphics2D, null, 1.0);
        Dimension2D dimension2D = textBlock.calculateDimension(uGraphicG2d.getStringBounder());
        graphics2D.dispose();
        emptyImageBuilder = new EmptyImageBuilder(dimension2D.getWidth(), dimension2D.getHeight(), colorMapper.getMappedColor(htmlColor));
        BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
        graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d2 = new UGraphicG2d(colorMapper, graphics2D, null, 1.0);
        textBlock.drawU(uGraphicG2d2, 0.0, 0.0);
        graphics2D.dispose();
        return bufferedImage;
    }
}

