/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMotif {
    private final List<Point2D> points = new ArrayList<Point2D>();

    public UMotif(int ... nArray) {
        for (int i = 0; i < nArray.length; i += 2) {
            this.points.add(new Point2D.Double(nArray[i], nArray[i + 1]));
        }
    }

    public UMotif(String string) {
        Point2D.Double double_ = new Point2D.Double();
        for (int i = 0; i < string.length(); ++i) {
            Point2D point2D = UMotif.convertPoint(string.charAt(i));
            ((Point2D)double_).setLocation(((Point2D)double_).getX() + point2D.getX(), ((Point2D)double_).getY() + point2D.getY());
            this.points.add(new Point2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY()));
        }
    }

    double getLength() {
        return this.points.get(0).distance(this.points.get(this.points.size() - 1));
    }

    List<Point2D> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public DotPath getRectangle(double d, double d2) {
        double d3 = this.getLength();
        int n = (int)(d / d3);
        DotPath dotPath = this.drawHorizontal(0.0, 0.0, n);
        int n2 = (int)(d2 / d3);
        DotPath dotPath2 = this.drawVertical(dotPath.getEndPoint().getX(), dotPath.getEndPoint().getY(), n2);
        dotPath = dotPath.addAfter(dotPath2);
        return dotPath;
    }

    static Point2D convertPoint(char c) {
        int n = UMotif.convertFromChar(c);
        int n2 = n % 7;
        int n3 = n / 7;
        return new Point2D.Double(n2 - 3, n3 - 3);
    }

    static int convertFromChar(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'w') {
            return c - 97 + 26;
        }
        throw new IllegalArgumentException();
    }

    public void drawHorizontal(UGraphic uGraphic, double d, double d2, int n) {
        DotPath dotPath = this.drawHorizontal(d, d2, n);
        uGraphic.draw(0.0, 0.0, dotPath);
    }

    public void drawVertical(UGraphic uGraphic, double d, double d2, int n) {
        DotPath dotPath = this.drawVertical(d, d2, n);
        uGraphic.draw(0.0, 0.0, dotPath);
    }

    DotPath drawHorizontal(double d, double d2, int n) {
        DotPath dotPath = new DotPath();
        for (int i = 0; i < n; ++i) {
            dotPath = this.addHorizontal(d, d2, dotPath);
            d = dotPath.getEndPoint().getX();
            d2 = dotPath.getEndPoint().getY();
        }
        return dotPath;
    }

    DotPath drawVertical(double d, double d2, int n) {
        DotPath dotPath = new DotPath();
        for (int i = 0; i < n; ++i) {
            dotPath = this.addVertical(d, d2, dotPath);
            d = dotPath.getEndPoint().getX();
            d2 = dotPath.getEndPoint().getY();
        }
        return dotPath;
    }

    private DotPath addHorizontal(double d, double d2, DotPath dotPath) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (Point2D point2D : this.points) {
            double d5 = d3 + d;
            double d6 = d4 + d2;
            double d7 = point2D.getX() + d;
            double d8 = point2D.getY() + d2;
            dotPath = dotPath.addAfter(new CubicCurve2D.Double(d5, d6, d5, d6, d7, d8, d7, d8));
            d3 = point2D.getX();
            d4 = point2D.getY();
        }
        return dotPath;
    }

    private DotPath addVertical(double d, double d2, DotPath dotPath) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (Point2D point2D : this.points) {
            double d5 = d3 + d;
            double d6 = d4 + d2;
            double d7 = point2D.getY() + d;
            double d8 = point2D.getX() + d2;
            dotPath = dotPath.addAfter(new CubicCurve2D.Double(d5, d6, d5, d6, d7, d8, d7, d8));
            d3 = point2D.getY();
            d4 = point2D.getX();
        }
        return dotPath;
    }
}

