/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPolygon
extends AbstractShadowable {
    private final List<Point2D.Double> all = new ArrayList<Point2D.Double>();
    private double minX = Double.MAX_VALUE;
    private double minY = Double.MAX_VALUE;
    private double maxX = -1.7976931348623157E308;
    private double maxY = -1.7976931348623157E308;

    public UPolygon() {
    }

    public UPolygon(List<Point2D.Double> list) {
        this.all.addAll(list);
        for (Point2D.Double double_ : this.all) {
            this.manageMinMax(double_.getX(), double_.getY());
        }
    }

    public void addPoint(double d, double d2) {
        this.all.add(new Point2D.Double(d, d2));
        this.manageMinMax(d, d2);
    }

    private void manageMinMax(double d, double d2) {
        if (d > this.maxX) {
            this.maxX = d;
        }
        if (d < this.minX) {
            this.minX = d;
        }
        if (d2 > this.maxY) {
            this.maxY = d2;
        }
        if (d2 < this.minY) {
            this.minY = d2;
        }
    }

    public List<Point2D.Double> getPoints() {
        return this.all;
    }

    public UPolygon translate(double d, double d2) {
        UPolygon uPolygon = new UPolygon();
        for (Point2D.Double double_ : this.all) {
            uPolygon.addPoint(double_.x + d, double_.y + d2);
        }
        return uPolygon;
    }

    public void rotate(double d) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d);
        for (Point2D.Double double_ : this.all) {
            affineTransform.transform(double_, double_);
        }
    }

    public String toString() {
        return super.toString() + " " + this.all;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }
}

