/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.UnusedSpace;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPixel;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.g2d.DriverDotPathG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverEllipseG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverImageG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverPathG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverPixelG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverPolygonG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverTextG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UGraphicG2d
extends AbstractUGraphic<Graphics2D>
implements EnsureVisible {
    private final BufferedImage bufferedImage;
    private final double dpiFactor;
    private final List<Url> urls = new ArrayList<Url>();

    public UGraphicG2d(ColorMapper colorMapper, Graphics2D graphics2D, BufferedImage bufferedImage, double d) {
        this(colorMapper, graphics2D, bufferedImage, d, null);
    }

    public UGraphicG2d(ColorMapper colorMapper, Graphics2D graphics2D, BufferedImage bufferedImage, double d, AffineTransform affineTransform) {
        super(colorMapper, graphics2D);
        this.dpiFactor = d;
        if (d != 1.0) {
            graphics2D.scale(d, d);
        }
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        this.bufferedImage = bufferedImage;
        this.registerDriver(URectangle.class, new DriverRectangleG2d(d, this));
        this.registerDriver(UText.class, new DriverTextG2d(this));
        this.registerDriver(ULine.class, new DriverLineG2d(d));
        this.registerDriver(UPixel.class, new DriverPixelG2d());
        this.registerDriver(UPolygon.class, new DriverPolygonG2d(d, this));
        this.registerDriver(UEllipse.class, new DriverEllipseG2d(d, this));
        this.registerDriver(UImage.class, new DriverImageG2d());
        this.registerDriver(DotPath.class, new DriverDotPathG2d(this));
        this.registerDriver(UPath.class, new DriverPathG2d(d));
    }

    @Override
    public StringBounder getStringBounder() {
        return StringBounderUtils.asStringBounder((Graphics2D)this.getGraphicObject());
    }

    public final BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    @Override
    public void setClip(UClip uClip) {
        if (uClip == null) {
            ((Graphics2D)this.getGraphicObject()).setClip(null);
        } else {
            Rectangle2D.Double double_ = new Rectangle2D.Double(uClip.getX() + this.getTranslateX(), uClip.getY() + this.getTranslateY(), uClip.getWidth(), uClip.getHeight());
            ((Graphics2D)this.getGraphicObject()).setClip(double_);
        }
    }

    @Override
    public void centerChar(double d, double d2, char c, UFont uFont) {
        UnusedSpace unusedSpace = UnusedSpace.getUnusedSpace(uFont, c);
        ((Graphics2D)this.getGraphicObject()).setColor(this.getColorMapper().getMappedColor(this.getParam().getColor()));
        double d3 = d - unusedSpace.getCenterX();
        double d4 = d2 - unusedSpace.getCenterY() - 0.5;
        ((Graphics2D)this.getGraphicObject()).setFont(uFont.getFont());
        ((Graphics2D)this.getGraphicObject()).drawString("" + c, (float)(d3 + this.getTranslateX()), (float)(d4 + this.getTranslateY()));
    }

    protected final double getDpiFactor() {
        return this.dpiFactor;
    }

    @Override
    public void setAntiAliasing(boolean bl) {
        if (bl) {
            ((Graphics2D)this.getGraphicObject()).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)this.getGraphicObject()).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    @Override
    public void startUrl(Url url) {
        this.urls.add(url);
    }

    @Override
    public void closeAction() {
        this.urls.remove(this.urls.size() - 1);
    }

    @Override
    public void ensureVisible(double d, double d2) {
        for (Url url : this.urls) {
            url.ensureVisible(d, d2);
        }
    }
}

