/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.PSystemBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockUml {
    private final List<? extends CharSequence> data;
    private PSystem system;
    private static final Pattern patternFilename = Pattern.compile("^@start[^\\s{}\"]+[\\s{][\\s\"]*([^\"]*?)[\\s}\"]*$");

    BlockUml(String ... stringArray) {
        this(Arrays.asList(stringArray));
    }

    public BlockUml(List<? extends CharSequence> list) {
        String string = ((Object)list.get(0)).toString().trim();
        if (!string.startsWith("@start")) {
            throw new IllegalArgumentException();
        }
        this.data = new ArrayList<CharSequence>(list);
    }

    public String getFilename() {
        if (OptionFlags.getInstance().isWord()) {
            return null;
        }
        Matcher matcher = patternFilename.matcher(((Object)this.data.get(0)).toString().trim());
        boolean bl = matcher.find();
        if (!bl) {
            return null;
        }
        String string = matcher.group(1);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("<>|".indexOf(c) == -1) continue;
            return null;
        }
        return string;
    }

    public PSystem getSystem() {
        if (this.system == null) {
            this.createSystem();
        }
        return this.system;
    }

    private void createSystem() {
        this.system = new PSystemBuilder().createPSystem(this.data);
    }
}

