/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class FileFormatOption {
    private final FileFormat fileFormat;
    private final AffineTransform affineTransform;

    public FileFormatOption(FileFormat fileFormat) {
        this(fileFormat, null);
    }

    public FileFormatOption(FileFormat fileFormat, AffineTransform affineTransform) {
        this.fileFormat = fileFormat;
        this.affineTransform = affineTransform;
    }

    public final FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public UGraphic createUGraphic(ColorMapper colorMapper, double d, Dimension2D dimension2D, HtmlColor htmlColor, boolean bl) {
        switch (this.fileFormat) {
            case PNG: {
                return this.createUGraphicPNG(colorMapper, d, dimension2D, htmlColor, bl);
            }
        }
        throw new UnsupportedOperationException();
    }

    private UGraphic createUGraphicPNG(ColorMapper colorMapper, double d, Dimension2D dimension2D, HtmlColor htmlColor, boolean bl) {
        Graphics2D graphics2D;
        EmptyImageBuilder emptyImageBuilder;
        Color color = Color.WHITE;
        if (htmlColor instanceof HtmlColorSimple) {
            color = colorMapper.getMappedColor(htmlColor);
        } else if (htmlColor instanceof HtmlColorTransparent) {
            color = null;
        }
        if (bl) {
            emptyImageBuilder = new EmptyImageBuilder((int)(dimension2D.getHeight() * d), (int)(dimension2D.getWidth() * d), color);
            graphics2D = emptyImageBuilder.getGraphics2D();
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-emptyImageBuilder.getBufferedImage().getHeight(), 0);
        } else {
            emptyImageBuilder = new EmptyImageBuilder((int)(dimension2D.getWidth() * d), (int)(dimension2D.getHeight() * d), color);
            graphics2D = emptyImageBuilder.getGraphics2D();
        }
        UGraphicG2d uGraphicG2d = new UGraphicG2d(colorMapper, graphics2D, d);
        uGraphicG2d.setBufferedImage(emptyImageBuilder.getBufferedImage());
        BufferedImage bufferedImage = uGraphicG2d.getBufferedImage();
        if (htmlColor instanceof HtmlColorGradient) {
            uGraphicG2d.getParam().setBackcolor(htmlColor);
            uGraphicG2d.draw(0.0, 0.0, new URectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
            uGraphicG2d.getParam().setBackcolor(null);
        }
        return uGraphicG2d;
    }
}

