/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLayoutStrategy;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ColorMapperMonochrome;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinParam
implements ISkinParam {
    private final Map<String, String> params = new HashMap<String, String>();
    private static final String stereoPatternString = "\\<\\<(.*?)\\>\\>";
    private static final Pattern stereoPattern = Pattern.compile("\\<\\<(.*?)\\>\\>");
    private final UmlDiagramType type;
    private final Map<String, Sprite> sprites = new HashMap<String, Sprite>();

    public void setParam(String string, String string2) {
        this.params.put(SkinParam.cleanForKey(string), string2.trim());
    }

    public SkinParam(UmlDiagramType umlDiagramType) {
        this.type = umlDiagramType;
        if (umlDiagramType == null) {
            this.setParam("shadowing", "false");
        }
    }

    static String cleanForKey(String string) {
        string = string.toLowerCase().trim();
        string = string.replaceAll("_|\\.|\\s", "");
        string = string.replaceAll("partition", "package");
        Matcher matcher = stereoPattern.matcher(string = string.replaceAll("componentarrow", "usecasearrow"));
        if (matcher.find()) {
            String string2 = matcher.group(1);
            string = string.replaceAll(stereoPatternString, "");
            string = string + "<<" + string2 + ">>";
        }
        return string;
    }

    @Override
    public HtmlColor getBackgroundColor() {
        HtmlColor htmlColor = this.getHtmlColor(ColorParam.background, null, false);
        if (htmlColor == null) {
            return HtmlColorUtils.WHITE;
        }
        return htmlColor;
    }

    @Override
    public String getValue(String string) {
        return this.params.get(SkinParam.cleanForKey(string));
    }

    static String humanName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                bl = true;
                continue;
            }
            stringBuilder.append(bl ? Character.toUpperCase(c) : Character.toLowerCase(c));
            bl = false;
        }
        return stringBuilder.toString();
    }

    @Override
    public HtmlColor getHtmlColor(ColorParam colorParam, String string, boolean bl) {
        boolean bl2;
        String string2;
        if (string != null) {
            this.checkStereotype(string);
            string2 = this.getValue(colorParam.name() + "color" + string);
            if (string2 != null && HtmlColorUtils.getColorIfValid(string2) != null) {
                return HtmlColorUtils.getColorIfValid(string2);
            }
        }
        string2 = this.getValue(this.getParamName(colorParam, bl));
        boolean bl3 = bl2 = colorParam == ColorParam.background;
        if (string2 == null) {
            return null;
        }
        return HtmlColorUtils.getColorIfValid(string2, bl2);
    }

    private String getParamName(ColorParam colorParam, boolean bl) {
        String string = colorParam.name();
        if (bl && string.endsWith("Background")) {
            string = string.replaceAll("Background", "ClickableBackground");
        } else if (bl && string.endsWith("Border")) {
            string = string.replaceAll("Border", "ClickableBorder");
        }
        return string + "color";
    }

    private void checkStereotype(String string) {
        if (!string.startsWith("<<") || !string.endsWith(">>")) {
            throw new IllegalArgumentException();
        }
    }

    private int getFontSize(FontParam fontParam, String string) {
        String string2;
        if (string != null) {
            this.checkStereotype(string);
            string2 = this.getValue(fontParam.name() + "fontsize" + string);
            if (string2 != null && string2.matches("\\d+")) {
                return Integer.parseInt(string2);
            }
        }
        if ((string2 = this.getValue(fontParam.name() + "fontsize")) == null || !string2.matches("\\d+")) {
            string2 = this.getValue("defaultfontsize");
        }
        if (string2 == null || !string2.matches("\\d+")) {
            return fontParam.getDefaultSize(this);
        }
        return Integer.parseInt(string2);
    }

    private String getFontFamily(FontParam fontParam, String string) {
        String string2;
        if (string != null) {
            this.checkStereotype(string);
            string2 = this.getValue(fontParam.name() + "fontname" + string);
            if (string2 != null) {
                return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
            }
        }
        if ((string2 = this.getValue(fontParam.name() + "fontname")) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        }
        if (fontParam != FontParam.CIRCLED_CHARACTER && (string2 = this.getValue("defaultfontname")) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        }
        return fontParam.getDefaultFamily();
    }

    @Override
    public HtmlColor getFontHtmlColor(FontParam fontParam, String string) {
        String string2 = null;
        if (string != null) {
            this.checkStereotype(string);
            string2 = this.getValue(fontParam.name() + "fontcolor" + string);
        }
        if (string2 == null || HtmlColorUtils.getColorIfValid(string2) == null) {
            string2 = this.getValue(fontParam.name() + "fontcolor");
        }
        if (string2 == null || HtmlColorUtils.getColorIfValid(string2) == null) {
            string2 = this.getValue("defaultfontcolor");
        }
        if (string2 == null || HtmlColorUtils.getColorIfValid(string2) == null) {
            string2 = fontParam.getDefaultColor();
        }
        return HtmlColorUtils.getColorIfValid(string2);
    }

    private int getFontStyle(FontParam fontParam, String string) {
        String string2 = null;
        if (string != null) {
            this.checkStereotype(string);
            string2 = this.getValue(fontParam.name() + "fontstyle" + string);
        }
        if (string2 == null) {
            string2 = this.getValue(fontParam.name() + "fontstyle");
        }
        if (string2 == null) {
            string2 = this.getValue("defaultfontstyle");
        }
        if (string2 == null) {
            return fontParam.getDefaultFontStyle(this);
        }
        int n = 0;
        if (string2.toLowerCase().contains("bold")) {
            n |= 1;
        }
        if (string2.toLowerCase().contains("italic")) {
            n |= 2;
        }
        return n;
    }

    @Override
    public UFont getFont(FontParam fontParam, String string) {
        if (string != null) {
            this.checkStereotype(string);
        }
        return new UFont(this.getFontFamily(fontParam, string), this.getFontStyle(fontParam, string), this.getFontSize(fontParam, string));
    }

    @Override
    public int getCircledCharacterRadius() {
        String string = this.getValue("circledcharacterradius");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return this.getFontSize(FontParam.CIRCLED_CHARACTER, null) / 3 + 6;
    }

    @Override
    public boolean isClassCollapse() {
        return true;
    }

    @Override
    public int classAttributeIconSize() {
        String string = this.getValue("classAttributeIconSize");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 10;
    }

    private boolean isMonochrome() {
        return "true".equals(this.getValue("monochrome"));
    }

    public static Collection<String> getPossibleValues() {
        String string;
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("Monochrome");
        treeSet.add("CircledCharacterRadius");
        treeSet.add("ClassAttributeIconSize");
        treeSet.add("DefaultFontName");
        treeSet.add("DefaultFontStyle");
        treeSet.add("DefaultFontSize");
        treeSet.add("DefaultFontColor");
        for (FontParam enum_ : EnumSet.allOf(FontParam.class)) {
            string = SkinParam.humanName(enum_.name());
            treeSet.add(string + "FontStyle");
            treeSet.add(string + "FontName");
            treeSet.add(string + "FontSize");
            treeSet.add(string + "FontColor");
        }
        for (ColorParam colorParam : EnumSet.allOf(ColorParam.class)) {
            string = SkinParam.capitalize(colorParam.name());
            treeSet.add(string + "Color");
        }
        return Collections.unmodifiableSet(treeSet);
    }

    private static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    @Override
    public int getDpi() {
        String string = this.getValue("dpi");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 96;
    }

    @Override
    public boolean useOctagonForActivity() {
        String string = this.getValue("activityshape");
        if ("roundedbox".equalsIgnoreCase(string)) {
            return false;
        }
        return "octagon".equalsIgnoreCase(string);
    }

    @Override
    public DotSplines getDotSplines() {
        String string = this.getValue("linetype");
        if ("polyline".equalsIgnoreCase(string)) {
            return DotSplines.POLYLINE;
        }
        if ("ortho".equalsIgnoreCase(string)) {
            return DotSplines.ORTHO;
        }
        return DotSplines.SPLINES;
    }

    @Override
    public GraphvizLayoutStrategy getStrategy() {
        String string = this.getValue("layout");
        if ("neato".equalsIgnoreCase(string)) {
            return GraphvizLayoutStrategy.NEATO;
        }
        if ("circo".equalsIgnoreCase(string)) {
            return GraphvizLayoutStrategy.CIRCO;
        }
        if ("fdp".equalsIgnoreCase(string)) {
            return GraphvizLayoutStrategy.FDP;
        }
        if ("twopi".equalsIgnoreCase(string)) {
            return GraphvizLayoutStrategy.TWOPI;
        }
        return GraphvizLayoutStrategy.DOT;
    }

    @Override
    public HorizontalAlignement getHorizontalAlignement(AlignParam alignParam) {
        String string;
        switch (alignParam) {
            case SEQUENCE_MESSAGE_ALIGN: {
                string = this.getArg(this.getValue(AlignParam.SEQUENCE_MESSAGE_ALIGN.name()), 0);
                break;
            }
            case SEQUENCE_MESSAGETEXT_ALIGN: {
                string = this.getArg(this.getValue(AlignParam.SEQUENCE_MESSAGE_ALIGN.name()), 1);
                break;
            }
            default: {
                string = this.getValue(alignParam.name());
            }
        }
        HorizontalAlignement horizontalAlignement = HorizontalAlignement.fromString(string);
        if (horizontalAlignement == null) {
            return alignParam.getDefaultValue();
        }
        return horizontalAlignement;
    }

    private String getArg(String string, int n) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(":");
        if (n >= stringArray.length) {
            return stringArray[0];
        }
        return stringArray[n];
    }

    @Override
    public ColorMapper getColorMapper() {
        if (this.isMonochrome()) {
            return new ColorMapperMonochrome();
        }
        return new ColorMapperIdentity();
    }

    @Override
    public boolean shadowing() {
        String string = this.getValue("shadowing");
        return !"false".equalsIgnoreCase(string);
    }

    @Override
    public PackageStyle getPackageStyle() {
        String string = this.getValue("packageStyle");
        PackageStyle packageStyle = PackageStyle.fromString(string);
        if (packageStyle == null) {
            return PackageStyle.FOLDER;
        }
        return packageStyle;
    }

    public void addSprite(String string, Sprite sprite) {
        this.sprites.put(string, sprite);
    }

    @Override
    public Sprite getSprite(String string) {
        return this.sprites.get(string);
    }

    @Override
    public boolean useUml2ForComponent() {
        String string = this.getValue("componentstyle");
        return "uml2".equalsIgnoreCase(string);
    }

    @Override
    public boolean stereotypePositionTop() {
        String string = this.getValue("stereotypePosition");
        return !"bottom".equalsIgnoreCase(string);
    }

    @Override
    public boolean useSwimlanes() {
        if (this.type != UmlDiagramType.ACTIVITY) {
            return false;
        }
        if ("true".equalsIgnoreCase(this.getValue("swimlane"))) {
            return true;
        }
        return "true".equalsIgnoreCase(this.getValue("swimlanes"));
    }

    @Override
    public double getNodesep() {
        String string = this.getValue("nodesep");
        if (string != null && string.matches("\\d+")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public double getRanksep() {
        String string = this.getValue("ranksep");
        if (string != null && string.matches("\\d+")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public double getRoundCorner() {
        String string = this.getValue("roundcorner");
        if (string != null && string.matches("\\d+")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public UStroke getThickness(LineParam lineParam) {
        String string = this.getValue(lineParam.name() + "thickness");
        if (string != null && string.matches("[\\d.]+")) {
            return new UStroke(Double.parseDouble(string));
        }
        return null;
    }
}

