/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.preproc.Defines;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileReader
implements ISourceFileReader {
    private final File file;
    private final File outputDirectory;
    private final BlockUmlBuilder builder;
    private FileFormatOption fileFormatOption;

    public SourceFileReader(File file) throws IOException {
        this(file, file.getAbsoluteFile().getParentFile());
    }

    public SourceFileReader(File file, File file2) throws IOException {
        this(new Defines(), file, file2, Collections.emptyList(), null, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(File file, File file2, FileFormatOption fileFormatOption) throws IOException {
        this(new Defines(), file, file2, Collections.emptyList(), null, fileFormatOption);
    }

    public SourceFileReader(Defines defines, File file, File file2, List<String> list, String string, FileFormatOption fileFormatOption) throws IOException {
        this.file = file;
        this.fileFormatOption = fileFormatOption;
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        FileSystem.getInstance().setCurrentDir(file.getAbsoluteFile().getParentFile());
        if (file2 == null) {
            file2 = file.getAbsoluteFile().getParentFile();
        } else if (!file2.isAbsolute()) {
            file2 = FileSystem.getInstance().getFile(file2.getName());
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        this.outputDirectory = file2;
        this.builder = new BlockUmlBuilder(list, defines, this.getReader(string), file.getAbsoluteFile().getParentFile());
    }

    @Override
    public boolean hasError() throws IOException, InterruptedException {
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            if (!(blockUml.getSystem() instanceof PSystemError)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<GeneratedImage> getGeneratedImages() throws IOException, InterruptedException {
        Log.info("Reading file: " + this.file);
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            String string = blockUml.getFilename();
            if (string == null) {
                string = this.fileFormatOption.getFileFormat().changeName(this.file.getName(), n++);
            }
            File file = new File(this.outputDirectory, string);
            file.getParentFile().mkdirs();
            PSystem pSystem = blockUml.getSystem();
            List<File> list = pSystem.exportDiagrams(file, this.fileFormatOption);
            OptionFlags.getInstance().logData(this.file, pSystem);
            for (File file2 : list) {
                Object object;
                String string2 = "[" + this.file.getName() + "] " + pSystem.getDescription();
                if (OptionFlags.getInstance().isWord() && (object = pSystem.getWarningOrError()) != null) {
                    String string3 = file2.getName().substring(0, file2.getName().length() - 4) + ".err";
                    File file3 = new File(file2.getParentFile(), string3);
                    PrintStream printStream = new PrintStream(new FileOutputStream(file3));
                    printStream.print((String)object);
                    printStream.close();
                }
                object = new GeneratedImage(file2, string2, pSystem);
                arrayList.add(object);
            }
        }
        Log.info("Number of image(s): " + arrayList.size());
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<String> getEncodedUrl() throws IOException, InterruptedException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            String string = blockUml.getSystem().getSource().getPlainString();
            String string2 = transcoder.encode(string);
            arrayList.add(string2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Reader getReader(String string) throws FileNotFoundException, UnsupportedEncodingException {
        if (string == null) {
            Log.info("Using default charset");
            return new InputStreamReader(new FileInputStream(this.file));
        }
        Log.info("Using charset " + string);
        return new InputStreamReader((InputStream)new FileInputStream(this.file), string);
    }

    public final void setFileFormatOption(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
    }

    public final Set<File> getIncludedFiles() {
        return this.builder.getIncludedFiles();
    }
}

