/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.acearth;

import com.ctreber.acearth.ACearth;
import com.ctreber.acearth.ConfigurationACearth;
import com.ctreber.acearth.plugins.markers.Marker;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.FileFormatOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemXearth
extends AbstractPSystem {
    private final int width;
    private final int height;
    private final Map<String, String> config;
    private final List<Marker> markers;
    private final Collection<String> enums = Arrays.asList("viewPositionType");
    private final Collection<String> doubles = Arrays.asList("sunPosRelLat", "sunPosRelLong", "orbitPeriod", "orbitInclination", "viewPosLat", "viewPosLong", "starFrequency", "viewMagnification");
    private final Collection<String> integers = Arrays.asList("daySideBrightness", "nightSideBrightness", "terminatorDiscontinuity", "gridDivision", "gridPixelDivision", "bigStars");
    private final Collection<String> booleans = Arrays.asList("shadeP", "gridP", "starsP");

    public PSystemXearth(int n, int n2, Map<String, String> map, List<Marker> list) {
        this.width = n;
        this.height = n2;
        this.config = map;
        this.markers = list;
    }

    @Override
    public void exportDiagram(OutputStream outputStream, CMapData cMapData, int n, FileFormatOption fileFormatOption) throws IOException {
        ACearth aCearth = new ACearth(this.markers);
        ConfigurationACearth configurationACearth = aCearth.getConf();
        configurationACearth.setInt("imageWidth", this.width);
        configurationACearth.setInt("imageHeight", this.height);
        for (Map.Entry<String, String> entry : this.config.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string.equalsIgnoreCase("GMT")) {
                Date date = this.extractGmt(string2);
                configurationACearth.setInt("fixedTime", (int)(date.getTime() / 1000L));
                continue;
            }
            if (this.enums.contains(string)) {
                configurationACearth.getMOEnum(string).set(string2);
                continue;
            }
            if (this.doubles.contains(string)) {
                configurationACearth.setDouble(string, Double.parseDouble(string2));
                continue;
            }
            if (this.integers.contains(string)) {
                configurationACearth.setInt(string, Integer.parseInt(string2));
                continue;
            }
            if (this.booleans.contains(string)) {
                configurationACearth.setBoolean(string, string2.equalsIgnoreCase("true"));
                continue;
            }
            throw new UnsupportedOperationException(string);
        }
        aCearth.exportPng(outputStream);
    }

    private Date extractGmt(String string) {
        SimpleDateFormat simpleDateFormat;
        if (string.matches("\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
            simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        } else if (string.matches("\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}")) {
            simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        } else {
            throw new UnsupportedOperationException(string);
        }
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new UnsupportedOperationException(string);
        }
    }

    @Override
    public String getDescription() {
        return "(XEarth)";
    }
}

