/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.activitydiagram.ConditionalContext;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityDiagram
extends CucaDiagram {
    private IEntity lastEntityConsulted;
    private IEntity lastEntityBrancheConsulted;
    private ConditionalContext currentContext;

    @Override
    public ILeaf getOrCreateLeaf1(Code code, LeafType leafType) {
        return this.getOrCreateLeaf1Default(code, leafType);
    }

    private String getAutoBranch() {
        return "#" + UniqueSequence.getValue();
    }

    public IEntity getOrCreate(Code code, Display display, LeafType leafType) {
        ILeaf iLeaf;
        if (this.leafExist(code)) {
            iLeaf = this.getOrCreateLeaf1Default(code, leafType);
            if (iLeaf.getEntityType() != leafType) {
                return null;
            }
        } else {
            iLeaf = this.createLeaf(code, display, leafType);
        }
        this.updateLasts(iLeaf);
        return iLeaf;
    }

    public void startIf(Code code) {
        ILeaf iLeaf = this.createLeaf(code == null ? Code.of(this.getAutoBranch()) : code, Display.asList(""), LeafType.BRANCH);
        this.currentContext = new ConditionalContext(this.currentContext, iLeaf, Direction.DOWN);
    }

    public void endif() {
        this.currentContext = this.currentContext.getParent();
    }

    public ILeaf getStart() {
        return (ILeaf)this.getOrCreate(Code.of("start"), Display.getWithNewlines("start"), LeafType.CIRCLE_START);
    }

    public ILeaf getEnd() {
        return (ILeaf)this.getOrCreate(Code.of("end"), Display.getWithNewlines("end"), LeafType.CIRCLE_END);
    }

    private void updateLasts(IEntity iEntity) {
        if (iEntity.getEntityType() == LeafType.NOTE) {
            return;
        }
        this.lastEntityConsulted = iEntity;
        if (iEntity.getEntityType() == LeafType.BRANCH) {
            this.lastEntityBrancheConsulted = iEntity;
        }
    }

    @Override
    public ILeaf createLeaf(Code code, Display display, LeafType leafType) {
        ILeaf iLeaf = super.createLeaf(code, display, leafType);
        this.updateLasts(iLeaf);
        return iLeaf;
    }

    public IEntity createNote(Code code, Display display) {
        return super.createLeaf(code, display, LeafType.NOTE);
    }

    @Override
    protected final List<String> getDotStrings() {
        return Arrays.asList("nodesep=.20;", "ranksep=0.4;", "edge [fontsize=11,labelfontsize=11];", "node [fontsize=11];");
    }

    @Override
    public String getDescription() {
        return "(" + this.getLeafs().size() + " activities)";
    }

    public IEntity getLastEntityConsulted() {
        return this.lastEntityConsulted;
    }

    @Deprecated
    public IEntity getLastEntityBrancheConsulted() {
        return this.lastEntityBrancheConsulted;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.ACTIVITY;
    }

    public final ConditionalContext getCurrentContext() {
        return this.currentContext;
    }

    public final void setLastEntityConsulted(IEntity iEntity) {
        this.lastEntityConsulted = iEntity;
    }

    public IEntity createInnerActivity() {
        Code code = Code.of("##" + UniqueSequence.getValue());
        IGroup iGroup = this.getOrCreateGroup(code, Display.getWithNewlines(code), null, GroupType.INNER_ACTIVITY, this.getCurrentGroup());
        this.lastEntityConsulted = null;
        this.lastEntityBrancheConsulted = null;
        return iGroup;
    }

    public void concurrentActivity(String string) {
        if (this.getCurrentGroup().zgetGroupType() == GroupType.CONCURRENT_ACTIVITY) {
            this.endGroup();
        }
        Code code = Code.of("##" + UniqueSequence.getValue());
        if (this.getCurrentGroup().zgetGroupType() != GroupType.INNER_ACTIVITY) {
            throw new IllegalStateException("type=" + (Object)((Object)this.getCurrentGroup().zgetGroupType()));
        }
        this.getOrCreateGroup(code, Display.getWithNewlines("code"), null, GroupType.CONCURRENT_ACTIVITY, this.getCurrentGroup());
        this.lastEntityConsulted = null;
        this.lastEntityBrancheConsulted = null;
    }
}

